"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestsSelectionControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _alerts = require("../../../common/utils/alerts");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disabledChecks = new Set(['errorMessages']);
const TestsSelectionControl = /*#__PURE__*/_react.default.memo(({
  config,
  onChange,
  errors
}) => {
  const uiConfig = (0, _alerts.getResultTestConfig)(config);
  const initConfig = (0, _react.useMemo)(() => {
    return uiConfig;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const updateCallback = (0, _react.useCallback)(update => {
    onChange({
      ...(config !== null && config !== void 0 ? config : {}),
      ...update
    });
  }, [onChange, config]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors
  }, Object.entries(uiConfig).filter(([name]) => !disabledChecks.has(name) || initConfig[name].enabled).map(([name, conf], i) => {
    var _TRANSFORM_HEALTH_CHE, _TRANSFORM_HEALTH_CHE2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      key: name,
      title: /*#__PURE__*/_react.default.createElement("h4", null, (_TRANSFORM_HEALTH_CHE = _constants.TRANSFORM_HEALTH_CHECK_NAMES[name]) === null || _TRANSFORM_HEALTH_CHE === void 0 ? void 0 : _TRANSFORM_HEALTH_CHE.name),
      description: (_TRANSFORM_HEALTH_CHE2 = _constants.TRANSFORM_HEALTH_CHECK_NAMES[name]) === null || _TRANSFORM_HEALTH_CHE2 === void 0 ? void 0 : _TRANSFORM_HEALTH_CHE2.description,
      fullWidth: true,
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.transform.alertTypes.transformHealth.testsSelection.enableTestLabel",
        defaultMessage: "Enable"
      }),
      onChange: updateCallback.bind(null, {
        [name]: {
          ...uiConfig[name],
          enabled: !uiConfig[name].enabled
        }
      }),
      checked: uiConfig[name].enabled
    })));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
});
exports.TestsSelectionControl = TestsSelectionControl;