"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyoutOverview = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_flyout_context = require("../../hooks/use_flyout_context");
var _common = require("../../../../constants/common");
var _indicator = require("../../../../../common/types/indicator");
var _unwrap_value = require("../../utils/unwrap_value");
var _empty_prompt = require("./empty_prompt");
var _block = require("./block");
var _highlighted_values_table = require("./highlighted_values_table");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const highLevelFields = [_indicator.RawIndicatorFieldId.Feed, _indicator.RawIndicatorFieldId.Type, _indicator.RawIndicatorFieldId.MarkingTLP, _indicator.RawIndicatorFieldId.Confidence];
const IndicatorsFlyoutOverview = ({
  indicator,
  onViewAllFieldsInTable
}) => {
  const {
    indicatorName
  } = (0, _use_flyout_context.useIndicatorsFlyoutContext)();
  const indicatorType = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Type);
  const highLevelBlocks = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS
  }, highLevelFields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field
  }, /*#__PURE__*/_react.default.createElement(_block.IndicatorBlock, {
    indicator: indicator,
    field: field,
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS
  })))), [indicator]);
  const indicatorDescription = (0, _react.useMemo)(() => {
    const unwrappedDescription = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Description);
    return unwrappedDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, unwrappedDescription) : null;
  }, [indicator]);
  const title = indicatorName != null ? indicatorName : (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Name) || _common.EMPTY_VALUE;
  if (!indicatorType) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_TITLE
  }, title)), indicatorDescription, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), highLevelBlocks, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicator.flyoutOverviewTable.highlightedFields",
    defaultMessage: "Highlighted fields"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onViewAllFieldsInTable
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicator.flyoutOverviewTable.viewAllFieldsInTable",
    defaultMessage: "View all fields in table"
  })))), /*#__PURE__*/_react.default.createElement(_highlighted_values_table.HighlightedValuesTable, {
    indicator: indicator,
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_TABLE
  }));
};
exports.IndicatorsFlyoutOverview = IndicatorsFlyoutOverview;