"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAttachmentsWithoutOwner = exports.generateAttachmentsMetadata = exports.generateAttachmentType = void 0;
var _common = require("@kbn/cases-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _common2 = require("../../../constants/common");
var _indicator = require("../../../../common/types/indicator");
var _field_value = require("../../indicators/utils/field_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const AttachmentChildrenLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/attachment_children'))));

/**
 * Create an {@link ExternalReferenceAttachmentType} object used to register an external reference
 * to the case plugin with our Threat Intelligence plugin initializes.
 *
 * See documentation here https://docs.elastic.dev/reops/attachment-framework-external-reference
 *
 * This object drives for example:
 * - the icon displayed in the case attachment
 * - the component that renders the comment in teh case attachment
 */
const generateAttachmentType = () => ({
  id: _constants.CASE_ATTACHMENT_TYPE_ID,
  displayName: 'indicator',
  getAttachmentViewObject: () => ({
    event: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.threatIntelligence.cases.eventDescription",
      defaultMessage: "added an indicator of compromise"
    }),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: "indicator",
      color: "subdued",
      iconType: "crosshairs"
    }),
    children: AttachmentChildrenLazy
  }),
  icon: 'crosshairs'
});

/**
 * Creates an attachment object, then passed to a case. It contains all the information necessary (id and metadata)
 * to allow the lazy loaded component defined within {@link generateAttachmentType} to render.
 *
 * See documentation here https://docs.elastic.dev/reops/attachment-framework-external-reference
 *
 * @param externalReferenceId the id saved in the case's attachment (in our case the indicator id)
 * @param attachmentMetadata some metadata also saved in the case's attachments for display in the comment
 */
exports.generateAttachmentType = generateAttachmentType;
const generateAttachmentsWithoutOwner = (externalReferenceId, attachmentMetadata) => {
  if (!externalReferenceId) {
    return [];
  }
  return [{
    type: _common.CommentType.externalReference,
    externalReferenceId,
    externalReferenceStorage: {
      type: _common.ExternalReferenceStorageType.elasticSearchDoc
    },
    externalReferenceAttachmentTypeId: _constants.CASE_ATTACHMENT_TYPE_ID,
    externalReferenceMetadata: attachmentMetadata
  }];
};

/**
 * To facilitate the rendering of the lazy loaded component defined in {@link generateAttachmentType}, we pass
 * some of the indicator's fields to be saved in the case's attachment.
 *
 * @param indicator the indicator we're attaching to a case
 */
exports.generateAttachmentsWithoutOwner = generateAttachmentsWithoutOwner;
const generateAttachmentsMetadata = indicator => {
  const indicatorName = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Name).value;
  const indicatorType = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Type).value;
  const indicatorFeedName = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Feed).value;
  return {
    indicatorName: indicatorName || _common2.EMPTY_VALUE,
    indicatorType: indicatorType || _common2.EMPTY_VALUE,
    indicatorFeedName: indicatorFeedName || _common2.EMPTY_VALUE
  };
};
exports.generateAttachmentsMetadata = generateAttachmentsMetadata;