"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INDICATOR_TYPE_TEST_ID = exports.INDICATOR_NAME_TEST_ID = exports.INDICATOR_FEED_NAME_TEST_ID = exports.CommentChildren = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _flyout = require("../../indicators/components/flyout/flyout");
var _styles = require("./styles");
var _use_indicator_by_id = require("../hooks/use_indicator_by_id");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDICATOR_NAME_TEST_ID = 'tiCasesIndicatorName';
exports.INDICATOR_NAME_TEST_ID = INDICATOR_NAME_TEST_ID;
const INDICATOR_FEED_NAME_TEST_ID = 'tiCasesIndicatorFeedName';
exports.INDICATOR_FEED_NAME_TEST_ID = INDICATOR_FEED_NAME_TEST_ID;
const INDICATOR_TYPE_TEST_ID = 'tiCasesIndicatorTYPE';
exports.INDICATOR_TYPE_TEST_ID = INDICATOR_TYPE_TEST_ID;
/**
 * Renders some basic values (indicator name, type and feed name) in the comment section
 * of the case attachment. Also renders a flyout for more details about the indicator.
 */
const CommentChildren = ({
  id,
  metadata
}) => {
  const styles = (0, _styles.useStyles)();
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const {
    indicator,
    isLoading
  } = (0, _use_indicator_by_id.useIndicatorById)(id);
  const {
    indicatorName,
    indicatorType,
    indicatorFeedName
  } = metadata;
  const flyoutFragment = (0, _react.useMemo)(() => expanded ? /*#__PURE__*/_react.default.createElement(_flyout.IndicatorsFlyout, {
    indicator: indicator,
    closeFlyout: () => setExpanded(false),
    kqlBarIntegration: true,
    indicatorName: indicatorName
  }) : null, [expanded, indicator, indicatorName]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      "data-test-subj": _test_ids.LOADING_LOGO_TEST_ID,
      logo: "logoSecurity",
      size: "xl"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.container,
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.cases.indicatorName",
    defaultMessage: "Indicator name:"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": INDICATOR_NAME_TEST_ID,
    onClick: () => setExpanded(true)
  }, indicatorName), ' '))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.cases.indicatorFeedName",
    defaultMessage: "Feed name:"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": INDICATOR_FEED_NAME_TEST_ID
  }, indicatorFeedName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.cases.indicatorType",
    defaultMessage: "Indicator type:"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": INDICATOR_TYPE_TEST_ID
  }, indicatorType))))), flyoutFragment);
};
exports.CommentChildren = CommentChildren;