"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsGuard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _test_ids = require("./test_ids");
var _use_integrations = require("../hooks/use_integrations");
var _empty_page = require("../modules/empty_page/empty_page");
var _use_total_count = require("../modules/indicators/hooks/use_total_count");
var _security_solution_plugin_template_wrapper = require("./security_solution_plugin_template_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders the indicators page if the user has some Threat Intelligence integrations installed or
 * the user is receiving indicators.
 * If none are received, show the EmptyPage with a link to go install integrations.
 * While the indicators call and the integrations call are loading, display a loading screen.
 */
const IntegrationsGuard = ({
  children
}) => {
  const {
    isLoading: indicatorsTotalCountLoading,
    count: indicatorsTotalCount
  } = (0, _use_total_count.useIndicatorsTotalCount)();
  const {
    isLoading: integrationLoading,
    data: installedTIIntegrations
  } = (0, _use_integrations.useIntegrations)();
  if (integrationLoading || indicatorsTotalCountLoading) {
    return /*#__PURE__*/_react.default.createElement(_security_solution_plugin_template_wrapper.SecuritySolutionPluginTemplateWrapper, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      "data-test-subj": _test_ids.LOADING_LOGO_TEST_ID,
      logo: "logoSecurity",
      size: "xl"
    }));
  }

  // show indicators page if there are indicators, or if some ti integrations have been added
  const showIndicatorsPage = indicatorsTotalCount > 0 || (installedTIIntegrations || []).length > 0;
  return showIndicatorsPage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, null);
};
exports.IntegrationsGuard = IntegrationsGuard;