"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TelemetryManagementSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/advanced-settings-plugin/public");
var _public2 = require("@kbn/usage-collection-plugin/public");
var _opt_in_example_flyout = require("./opt_in_example_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SEARCH_TERMS = ['telemetry', 'usage data',
// Keeping this term for BWC
'usage collection', _i18n.i18n.translate('telemetry.telemetryConstant', {
  defaultMessage: 'telemetry'
}), _i18n.i18n.translate('telemetry.usageCollectionConstant', {
  defaultMessage: 'usage collection'
})].flatMap(term => {
  // Automatically lower-case and split by space the terms from above
  const lowerCased = term.toLowerCase();
  return [lowerCased, ...lowerCased.split(' ')];
});
class TelemetryManagementSection extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "maybeGetAppliesSettingMessage", () => {
      if (!this.props.showAppliesSettingMessage) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "primary",
        iconType: "spacesApp",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "telemetry.callout.appliesSettingTitle",
          defaultMessage: "Changes to this setting apply to {allOfKibanaText} and are saved automatically.",
          values: {
            allOfKibanaText: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "telemetry.callout.appliesSettingTitle.allOfKibanaText",
              defaultMessage: "all of Kibana"
            }))
          }
        })
      });
    });
    (0, _defineProperty2.default)(this, "renderDescription", () => {
      const {
        docLinks
      } = this.props;
      const clusterDataLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: this.toggleExample,
        "data-test-id": "cluster_data_example"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.clusterData",
        defaultMessage: "cluster data"
      }));
      const securityDataLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/advanced-settings.html#telemetry-settings",
        "data-test-id": "endpoint_security_example",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.securityData",
        defaultMessage: "security data"
      }));
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.telemetryConfigAndLinkDescription",
        defaultMessage: "Enabling usage collection allows us to learn what our users are most interested in, so we can improve our products and services. Refer to our {privacyStatementLink}.",
        values: {
          privacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.legal.privacyStatement,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "telemetry.readOurUsageDataPrivacyStatementLinkText",
            defaultMessage: "Privacy Statement"
          }))
        }
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.seeExampleOfClusterDataAndEndpointSecuity",
        defaultMessage: "See examples of the {clusterData} and {securityData} that we collect.",
        values: {
          clusterData: clusterDataLink,
          securityData: securityDataLink
        }
      })));
    });
    (0, _defineProperty2.default)(this, "toggleOptIn", async () => {
      const {
        telemetryService,
        toasts
      } = this.props;
      const newOptInValue = !this.state.enabled;
      return new Promise((resolve, reject) => {
        this.setState({
          processing: true,
          enabled: newOptInValue
        }, async () => {
          try {
            await telemetryService.setOptIn(newOptInValue);
            this.setState({
              processing: false
            });
            toasts.addSuccess(newOptInValue ? _i18n.i18n.translate('telemetry.optInSuccessOn', {
              defaultMessage: 'Sharing usage with Elastic is enabled.'
            }) : _i18n.i18n.translate('telemetry.optInSuccessOff', {
              defaultMessage: 'No longer sharing usage with Elastic.'
            }));
            resolve(true);
          } catch (err) {
            this.setState({
              processing: false
            });
            reject(err);
          }
        });
      });
    });
    (0, _defineProperty2.default)(this, "toggleExample", () => {
      this.setState({
        showExample: !this.state.showExample
      });
    });
    this.state = {
      processing: false,
      showExample: false,
      showSecurityExample: false,
      queryMatches: props.query ? this.checkQueryMatch(props.query) : null,
      enabled: this.props.telemetryService.getIsOptedIn() || false
    };
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    const {
      query
    } = nextProps;
    const queryMatches = this.checkQueryMatch(query);
    if (queryMatches !== this.state.queryMatches) {
      this.setState({
        queryMatches
      }, () => {
        this.props.onQueryMatchChange(queryMatches);
      });
    }
  }
  checkQueryMatch(query) {
    var _query$text;
    const searchTerm = ((_query$text = query === null || query === void 0 ? void 0 : query.text) !== null && _query$text !== void 0 ? _query$text : '').toLowerCase();
    return this.props.telemetryService.getCanChangeOptInStatus() && SEARCH_TERMS.some(term => term.indexOf(searchTerm) >= 0);
  }
  render() {
    const {
      telemetryService
    } = this.props;
    const {
      showExample,
      queryMatches,
      enabled,
      processing
    } = this.state;
    if (!telemetryService.getCanChangeOptInStatus()) {
      return null;
    }
    if (queryMatches !== null && !queryMatches) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, showExample && /*#__PURE__*/_react.default.createElement(_public2.TrackApplicationView, {
      viewId: "optInExampleFlyout"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(_opt_in_example_flyout.OptInExampleFlyout, {
      fetchExample: telemetryService.fetchExample,
      onClose: this.toggleExample
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "telemetry.usageDataTitle",
      defaultMessage: "Usage collection"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, this.maybeGetAppliesSettingMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_public.LazyField, {
      setting: {
        type: 'boolean',
        name: 'Usage collection',
        displayName: _i18n.i18n.translate('telemetry.provideUsageDataTitle', {
          defaultMessage: 'Share usage with Elastic'
        }),
        value: enabled,
        description: this.renderDescription(),
        defVal: true,
        ariaName: _i18n.i18n.translate('telemetry.provideUsageDataAriaName', {
          defaultMessage: 'Share usage with Elastic'
        }),
        requiresPageReload: false,
        category: [],
        isOverridden: false,
        isCustom: true
      },
      loading: processing,
      docLinks: this.props.docLinks,
      toasts: this.props.toasts,
      handleChange: this.toggleOptIn,
      enableSaving: this.props.enableSaving
    })))));
  }
}

// required for lazy loading
// eslint-disable-next-line import/no-default-export
exports.TelemetryManagementSection = TelemetryManagementSection;
var _default = TelemetryManagementSection;
exports.default = _default;