"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlsFormatters = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _formatting_utils = require("./formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tlsFormatters = {
  [_runtime_types.ConfigKey.TLS_CERTIFICATE_AUTHORITIES]: _formatting_utils.tlsValueToYamlFormatter,
  [_runtime_types.ConfigKey.TLS_CERTIFICATE]: _formatting_utils.tlsValueToYamlFormatter,
  [_runtime_types.ConfigKey.TLS_KEY]: _formatting_utils.tlsValueToYamlFormatter,
  [_runtime_types.ConfigKey.TLS_KEY_PASSPHRASE]: _formatting_utils.tlsValueToStringFormatter,
  [_runtime_types.ConfigKey.TLS_VERIFICATION_MODE]: _formatting_utils.tlsValueToStringFormatter,
  [_runtime_types.ConfigKey.TLS_VERSION]: _formatting_utils.tlsArrayToYamlFormatter
};
exports.tlsFormatters = tlsFormatters;