"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.httpFormatters = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _tls_formatters = require("./tls_formatters");
var _common_formatters = require("./common_formatters");
var _formatting_utils = require("./formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const httpFormatters = {
  ..._common_formatters.commonFormatters,
  ..._tls_formatters.tlsFormatters,
  [_runtime_types.ConfigKey.MAX_REDIRECTS]: null,
  [_runtime_types.ConfigKey.REQUEST_METHOD_CHECK]: null,
  [_runtime_types.ConfigKey.RESPONSE_BODY_INDEX]: null,
  [_runtime_types.ConfigKey.RESPONSE_HEADERS_INDEX]: null,
  [_runtime_types.ConfigKey.METADATA]: _formatting_utils.objectToJsonFormatter,
  [_runtime_types.ConfigKey.URLS]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.USERNAME]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PASSWORD]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PROXY_URL]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PROXY_HEADERS]: _formatting_utils.objectToJsonFormatter,
  [_runtime_types.ConfigKey.PORT]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.RESPONSE_JSON_CHECK]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.RESPONSE_HEADERS_CHECK]: _formatting_utils.objectToJsonFormatter,
  [_runtime_types.ConfigKey.RESPONSE_STATUS_CHECK]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.REQUEST_HEADERS_CHECK]: _formatting_utils.objectToJsonFormatter,
  [_runtime_types.ConfigKey.REQUEST_BODY_CHECK]: fields => {
    var _fields$ConfigKey$REQ, _fields$ConfigKey$REQ2;
    return (_fields$ConfigKey$REQ = fields[_runtime_types.ConfigKey.REQUEST_BODY_CHECK]) !== null && _fields$ConfigKey$REQ !== void 0 && _fields$ConfigKey$REQ.value ? JSON.stringify((_fields$ConfigKey$REQ2 = fields[_runtime_types.ConfigKey.REQUEST_BODY_CHECK]) === null || _fields$ConfigKey$REQ2 === void 0 ? void 0 : _fields$ConfigKey$REQ2.value) : null;
  },
  [_runtime_types.ConfigKey.RESPONSE_BODY_MAX_BYTES]: null,
  [_runtime_types.ConfigKey.MODE]: null,
  [_runtime_types.ConfigKey.IPV4]: null,
  [_runtime_types.ConfigKey.IPV6]: null
};
exports.httpFormatters = httpFormatters;