"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentPoliciesRoute = exports.getAgentPoliciesAsInternalUser = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentPoliciesRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.AGENT_POLICIES,
  validate: {},
  handler: async ({
    server
  }) => {
    return getAgentPoliciesAsInternalUser(server);
  }
});
exports.getAgentPoliciesRoute = getAgentPoliciesRoute;
const getAgentPoliciesAsInternalUser = async server => {
  var _server$fleet;
  const soClient = server.coreStart.savedObjects.createInternalRepository();
  const esClient = server.coreStart.elasticsearch.client.asInternalUser;
  return (_server$fleet = server.fleet) === null || _server$fleet === void 0 ? void 0 : _server$fleet.agentPolicyService.list(soClient, {
    page: 1,
    perPage: 10000,
    sortField: 'name',
    sortOrder: 'asc',
    kuery: 'ingest-agent-policies.is_managed : false',
    esClient,
    withAgentCount: true
  });
};
exports.getAgentPoliciesAsInternalUser = getAgentPoliciesAsInternalUser;