"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addPrivateLocationRoute = exports.PrivateLocationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_private_locations = require("./get_private_locations");
var _private_locations = require("../../../../common/saved_objects/private_locations");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateLocationSchema = _configSchema.schema.object({
  label: _configSchema.schema.string(),
  id: _configSchema.schema.string(),
  agentPolicyId: _configSchema.schema.string(),
  concurrentMonitors: _configSchema.schema.number(),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  geo: _configSchema.schema.maybe(_configSchema.schema.object({
    lat: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    lon: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()])
  }))
});
exports.PrivateLocationSchema = PrivateLocationSchema;
const addPrivateLocationRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS,
  validate: {
    body: PrivateLocationSchema
  },
  writeAccess: true,
  handler: async ({
    request,
    server,
    savedObjectsClient
  }) => {
    const location = request.body;
    const {
      locations
    } = await (0, _get_private_locations.getAllPrivateLocations)(savedObjectsClient);
    const existingLocations = locations.filter(loc => loc.id !== location.agentPolicyId);
    const result = await savedObjectsClient.create(_private_locations.privateLocationsSavedObjectName, {
      locations: [...existingLocations, location]
    }, {
      id: _private_locations.privateLocationsSavedObjectId,
      overwrite: true
    });
    return result.attributes;
  }
});
exports.addPrivateLocationRoute = addPrivateLocationRoute;