"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSyntheticsParamsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("@kbn/security-plugin/common/constants");
var _common = require("@kbn/spaces-plugin/common");
var _saved_objects = require("../../../common/types/saved_objects");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addSyntheticsParamsRoute = () => ({
  method: 'POST',
  path: _constants2.SYNTHETICS_API_URLS.PARAMS,
  validate: {
    body: _configSchema.schema.object({
      key: _configSchema.schema.string(),
      value: _configSchema.schema.string(),
      description: _configSchema.schema.maybe(_configSchema.schema.string()),
      tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      share_across_spaces: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })
  },
  writeAccess: true,
  handler: async ({
    request,
    response,
    server,
    savedObjectsClient
  }) => {
    try {
      var _await$server$spaces$, _server$spaces;
      const {
        id: spaceId
      } = (_await$server$spaces$ = await ((_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getActiveSpace(request))) !== null && _await$server$spaces$ !== void 0 ? _await$server$spaces$ : {
        id: _common.DEFAULT_SPACE_ID
      };
      const {
        share_across_spaces: shareAcrossSpaces,
        ...data
      } = request.body;
      const result = await savedObjectsClient.create(_saved_objects.syntheticsParamType, data, {
        initialNamespaces: shareAcrossSpaces ? [_constants.ALL_SPACES_ID] : [spaceId]
      });
      return {
        data: result
      };
    } catch (error) {
      var _error$output;
      if (((_error$output = error.output) === null || _error$output === void 0 ? void 0 : _error$output.statusCode) === 404) {
        var _server$spaces$spaces, _server$spaces2;
        const spaceId = (_server$spaces$spaces = (_server$spaces2 = server.spaces) === null || _server$spaces2 === void 0 ? void 0 : _server$spaces2.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
        return response.notFound({
          body: {
            message: `Kibana space '${spaceId}' does not exist`
          }
        });
      }
      throw error;
    }
  }
});
exports.addSyntheticsParamsRoute = addSyntheticsParamsRoute;