"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLastSuccessfulCheckRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _last_successful_check = require("../../legacy_uptime/routes/synthetics/last_successful_check");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLastSuccessfulCheckRoute = libs => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_SUCCESSFUL_CHECK,
  validate: {
    query: _configSchema.schema.object({
      monitorId: _configSchema.schema.string(),
      stepIndex: _configSchema.schema.number(),
      timestamp: _configSchema.schema.string(),
      location: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  },
  handler: async routeProps => {
    return await (0, _last_successful_check.getLastSuccessfulCheckScreenshot)(routeProps);
  }
});
exports.createLastSuccessfulCheckRoute = createLastSuccessfulCheckRoute;