"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJourneyScreenshotRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
var _journey_screenshots = require("../../legacy_uptime/routes/pings/journey_screenshots");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createJourneyScreenshotRoute = libs => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.JOURNEY_SCREENSHOT,
  validate: {
    params: _configSchema.schema.object({
      checkGroup: _configSchema.schema.string(),
      stepIndex: _configSchema.schema.number()
    })
  },
  handler: async routeProps => {
    return await (0, _journey_screenshots.journeyScreenshotHandler)(routeProps);
  }
});
exports.createJourneyScreenshotRoute = createJourneyScreenshotRoute;