"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSyntheticsProjectMonitorRouteLegacy = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PAYLOAD_SIZE = 1048576 * 20; // 20MiB

const addSyntheticsProjectMonitorRouteLegacy = libs => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS_PROJECT_LEGACY,
  validate: {
    body: _configSchema.schema.object({
      project: _configSchema.schema.string(),
      keep_stale: _configSchema.schema.boolean(),
      monitors: _configSchema.schema.arrayOf(_configSchema.schema.any())
    })
  },
  options: {
    body: {
      maxBytes: MAX_PAYLOAD_SIZE
    }
  },
  handler: async ({
    server,
    subject,
    request
  }) => {
    var _request$body;
    const monitors = ((_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.monitors) || [];
    const failureMessage = _i18n.i18n.translate('xpack.synthetics.server.projectMonitors.legacy.error', {
      defaultMessage: `Failed to create monitor`
    });
    const deprecationNotice = _i18n.i18n.translate('xpack.synthetics.server.projectMonitors.legacy.deprecation', {
      defaultMessage: `This version of @elastic/synthetics is not supported in Kibana {version}. Please upgrade to ^1.0.0.`,
      values: {
        version: server.stackVersion
      }
    });
    subject === null || subject === void 0 ? void 0 : subject.next(deprecationNotice);
    subject === null || subject === void 0 ? void 0 : subject.next({
      failedMonitors: monitors.map(m => ({
        id: m.id,
        reason: failureMessage,
        details: deprecationNotice
      })),
      createdMonitors: [],
      updatedMonitors: [],
      staleMonitors: [],
      deletedMonitors: [],
      failedStaleMonitors: []
    });
    subject === null || subject === void 0 ? void 0 : subject.complete();
  }
});
exports.addSyntheticsProjectMonitorRouteLegacy = addSyntheticsProjectMonitorRouteLegacy;