"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultAlertService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("../../legacy_uptime/lib/saved_objects");
var _alert_actions = require("../../../common/rules/alert_actions");
var _translations = require("../../../common/rules/synthetics/translations");
var _synthetics_alerts = require("../../../common/constants/synthetics_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DefaultAlertService {
  constructor(context, server, soClient) {
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "soClient", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    this.context = context;
    this.server = server;
    this.soClient = soClient;
  }
  async setupDefaultAlerts() {
    const [statusRule, tlsRule] = await Promise.allSettled([this.setupStatusRule(), this.setupTlsRule()]);
    if (statusRule.status === 'rejected') {
      throw statusRule.reason;
    }
    if (tlsRule.status === 'rejected') {
      throw tlsRule.reason;
    }
    return {
      statusRule: statusRule.status === 'fulfilled' ? statusRule.value : null,
      tlsRule: tlsRule.status === 'fulfilled' ? tlsRule.value : null
    };
  }
  setupStatusRule() {
    return this.createDefaultAlertIfNotExist(_synthetics_alerts.SYNTHETICS_STATUS_RULE, `Synthetics status internal alert`, '1m');
  }
  setupTlsRule() {
    return this.createDefaultAlertIfNotExist(_synthetics_alerts.SYNTHETICS_TLS_RULE, `Synthetics internal TLS alert`, '1m');
  }
  async getExistingAlert(ruleType) {
    var _await$this$context$a;
    const rulesClient = (_await$this$context$a = await this.context.alerting) === null || _await$this$context$a === void 0 ? void 0 : _await$this$context$a.getRulesClient();
    const {
      data
    } = await rulesClient.find({
      options: {
        page: 1,
        perPage: 1,
        filter: `alert.attributes.alertTypeId:(${ruleType})`
      }
    });
    const alert = data === null || data === void 0 ? void 0 : data[0];
    if (!alert) {
      return;
    }
    return {
      ...alert,
      ruleTypeId: alert.alertTypeId
    };
  }
  async createDefaultAlertIfNotExist(ruleType, name, interval) {
    var _await$this$context$a2;
    const alert = await this.getExistingAlert(ruleType);
    if (alert) {
      return alert;
    }
    const actions = await this.getAlertActions(ruleType);
    const rulesClient = (_await$this$context$a2 = await this.context.alerting) === null || _await$this$context$a2 === void 0 ? void 0 : _await$this$context$a2.getRulesClient();
    const newAlert = await rulesClient.create({
      data: {
        actions,
        params: {},
        consumer: 'uptime',
        alertTypeId: ruleType,
        schedule: {
          interval
        },
        tags: ['SYNTHETICS_DEFAULT_ALERT'],
        name,
        enabled: true,
        throttle: null
      }
    });
    return {
      ...newAlert,
      ruleTypeId: newAlert.alertTypeId
    };
  }
  updateStatusRule() {
    return this.updateDefaultAlert(_synthetics_alerts.SYNTHETICS_STATUS_RULE, `Synthetics status internal alert`, '1m');
  }
  updateTlsRule() {
    return this.updateDefaultAlert(_synthetics_alerts.SYNTHETICS_TLS_RULE, `Synthetics internal TLS alert`, '1m');
  }
  async updateDefaultAlert(ruleType, name, interval) {
    var _await$this$context$a3;
    const rulesClient = (_await$this$context$a3 = await this.context.alerting) === null || _await$this$context$a3 === void 0 ? void 0 : _await$this$context$a3.getRulesClient();
    const alert = await this.getExistingAlert(ruleType);
    if (alert) {
      const actions = await this.getAlertActions(ruleType);
      const updatedAlert = await rulesClient.update({
        id: alert.id,
        data: {
          actions,
          name: alert.name,
          tags: alert.tags,
          schedule: alert.schedule,
          params: alert.params
        }
      });
      return {
        ...updatedAlert,
        ruleTypeId: updatedAlert.alertTypeId
      };
    }
    return await this.createDefaultAlertIfNotExist(ruleType, name, interval);
  }
  async getAlertActions(ruleType) {
    const {
      actionConnectors,
      settings
    } = await this.getActionConnectors();
    const defaultActions = (actionConnectors !== null && actionConnectors !== void 0 ? actionConnectors : []).filter(act => {
      var _settings$defaultConn;
      return settings === null || settings === void 0 ? void 0 : (_settings$defaultConn = settings.defaultConnectors) === null || _settings$defaultConn === void 0 ? void 0 : _settings$defaultConn.includes(act.id);
    });
    if (ruleType === _synthetics_alerts.SYNTHETICS_STATUS_RULE) {
      return (0, _alert_actions.populateAlertActions)({
        defaultActions,
        groupId: _synthetics_alerts.ACTION_GROUP_DEFINITIONS.MONITOR_STATUS.id,
        defaultEmail: settings === null || settings === void 0 ? void 0 : settings.defaultEmail,
        translations: {
          defaultActionMessage: _translations.SyntheticsMonitorStatusTranslations.defaultActionMessage,
          defaultRecoveryMessage: _translations.SyntheticsMonitorStatusTranslations.defaultRecoveryMessage,
          defaultSubjectMessage: _translations.SyntheticsMonitorStatusTranslations.defaultSubjectMessage,
          defaultRecoverySubjectMessage: _translations.SyntheticsMonitorStatusTranslations.defaultRecoverySubjectMessage
        }
      });
    } else {
      return (0, _alert_actions.populateAlertActions)({
        defaultActions,
        groupId: _synthetics_alerts.ACTION_GROUP_DEFINITIONS.TLS_CERTIFICATE.id,
        defaultEmail: settings === null || settings === void 0 ? void 0 : settings.defaultEmail,
        translations: {
          defaultActionMessage: _translations.TlsTranslations.defaultActionMessage,
          defaultRecoveryMessage: _translations.TlsTranslations.defaultRecoveryMessage,
          defaultSubjectMessage: _translations.TlsTranslations.defaultSubjectMessage,
          defaultRecoverySubjectMessage: _translations.TlsTranslations.defaultRecoverySubjectMessage
        }
      });
    }
  }
  async getActionConnectors() {
    var _await$this$context$a4;
    const actionsClient = (_await$this$context$a4 = await this.context.actions) === null || _await$this$context$a4 === void 0 ? void 0 : _await$this$context$a4.getActionsClient();
    const settings = await _saved_objects.savedObjectsAdapter.getUptimeDynamicSettings(this.soClient);
    let actionConnectors = [];
    try {
      actionConnectors = await actionsClient.getAll();
    } catch (e) {
      this.server.logger.error(e);
    }
    return {
      actionConnectors,
      settings
    };
  }
}
exports.DefaultAlertService = DefaultAlertService;