"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsCertsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_all_monitors = require("../../saved_objects/synthetics_monitor/get_all_monitors");
var _saved_objects = require("../../../common/types/saved_objects");
var _get_certs = require("../../legacy_uptime/lib/requests/get_certs");
var _constants = require("../../../common/constants");
var _monitor_management = require("../../../common/constants/monitor_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsCertsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.CERTS,
  validate: {
    query: _configSchema.schema.object({
      pageIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
      size: _configSchema.schema.maybe(_configSchema.schema.number()),
      sortBy: _configSchema.schema.maybe(_configSchema.schema.string()),
      direction: _configSchema.schema.maybe(_configSchema.schema.string()),
      search: _configSchema.schema.maybe(_configSchema.schema.string()),
      from: _configSchema.schema.maybe(_configSchema.schema.string()),
      to: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  },
  handler: async ({
    request,
    uptimeEsClient,
    savedObjectsClient,
    server,
    syntheticsMonitorClient
  }) => {
    const queryParams = request.query;
    const monitors = await (0, _get_all_monitors.getAllMonitors)({
      soClient: savedObjectsClient,
      filter: `${_saved_objects.monitorAttributes}.${_monitor_management.AlertConfigKey.STATUS_ENABLED}: true`
    });
    if (monitors.length === 0) {
      return {
        data: {
          certs: [],
          total: 0
        }
      };
    }
    const {
      enabledMonitorQueryIds
    } = await (0, _get_all_monitors.processMonitors)(monitors, server, savedObjectsClient, syntheticsMonitorClient);
    const data = await (0, _get_certs.getCerts)({
      ...queryParams,
      uptimeEsClient,
      monitorIds: enabledMonitorQueryIds
    });
    return {
      data
    };
  }
});
exports.getSyntheticsCertsRoute = getSyntheticsCertsRoute;