"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChecksNavigation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _monitor_status_column = require("../../components/overview/monitor_list/columns/monitor_status_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChecksNavigation = ({
  timestamp,
  details
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const isMobile = (0, _eui.useIsWithinMaxBreakpoint)('s');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsChecksNavigationPreviousCheckButton",
    size: isMobile ? 'xs' : 'm',
    iconType: "arrowLeft",
    isDisabled: !(details !== null && details !== void 0 && details.previous),
    onClick: () => {
      var _details$previous;
      history.push(`/journey/${details === null || details === void 0 ? void 0 : (_details$previous = details.previous) === null || _details$previous === void 0 ? void 0 : _details$previous.checkGroup}/steps`);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepList.previousCheck",
    defaultMessage: "Previous check"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: isMobile ? 'xs' : 'm',
    className: "eui-textNoWrap"
  }, (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(timestamp)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsChecksNavigationNextCheckButton",
    size: isMobile ? 'xs' : 'm',
    iconType: "arrowRight",
    iconSide: "right",
    isDisabled: !(details !== null && details !== void 0 && details.next),
    onClick: () => {
      var _details$next;
      history.push(`/journey/${details === null || details === void 0 ? void 0 : (_details$next = details.next) === null || _details$next === void 0 ? void 0 : _details$next.checkGroup}/steps`);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepList.nextCheck",
    defaultMessage: "Next check"
  }))));
};
exports.ChecksNavigation = ChecksNavigation;