"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mount = mount;
exports.mountWithRouterRedux = exports.mountWithRouter = void 0;
exports.render = render;
exports.shallowWithRouterRedux = exports.shallowWithRouter = exports.renderWithRouterRedux = exports.renderWithRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _history = require("history");
var _testJestHelpers = require("@kbn/test-jest-helpers");
var _helper_with_redux = require("./helper_with_redux");
var _uptime_store = require("../__mocks__/uptime_store.mock");
var _rtl_helpers = require("./rtl_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const helperWithRouter = (helper, component, customHistory, wrapReduxStore, storeState) => {
  const history = customHistory !== null && customHistory !== void 0 ? customHistory : (0, _history.createMemoryHistory)();
  history.location.key = 'TestKeyForTesting';
  const routerWrapper = /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, component);
  if (wrapReduxStore) {
    return helper( /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
      state: storeState
    }, routerWrapper));
  }
  return helper(routerWrapper);
};
const renderWithRouter = (component, customHistory) => {
  return helperWithRouter(_testJestHelpers.renderWithIntl, component, customHistory);
};
exports.renderWithRouter = renderWithRouter;
const shallowWithRouter = (component, customHistory) => {
  return helperWithRouter(_testJestHelpers.shallowWithIntl, component, customHistory);
};
exports.shallowWithRouter = shallowWithRouter;
const mountWithRouter = (component, customHistory) => {
  return helperWithRouter(_testJestHelpers.mountWithIntl, component, customHistory);
};
exports.mountWithRouter = mountWithRouter;
const renderWithRouterRedux = (component, customHistory) => {
  return helperWithRouter(_testJestHelpers.renderWithIntl, component, customHistory, true);
};
exports.renderWithRouterRedux = renderWithRouterRedux;
const shallowWithRouterRedux = (component, customHistory) => {
  return helperWithRouter(_testJestHelpers.shallowWithIntl, component, customHistory, true);
};
exports.shallowWithRouterRedux = shallowWithRouterRedux;
const mountWithRouterRedux = (component, options) => {
  return helperWithRouter(_testJestHelpers.mountWithIntl, component, options === null || options === void 0 ? void 0 : options.customHistory, true, options === null || options === void 0 ? void 0 : options.storeState);
};

/* Custom enzyme render */
exports.mountWithRouterRedux = mountWithRouterRedux;
function render(ui, {
  history,
  core,
  kibanaProps,
  state
} = {}) {
  const testState = {
    ..._uptime_store.mockState,
    ...state
  };
  return (0, _testJestHelpers.renderWithIntl)( /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
    state: testState
  }, /*#__PURE__*/_react.default.createElement(_rtl_helpers.MockRouter, {
    history: history,
    kibanaProps: kibanaProps,
    core: core
  }, ui)));
}

/* Custom enzyme render */
function mount(ui, {
  history,
  core,
  kibanaProps,
  state
} = {}) {
  const testState = {
    ..._uptime_store.mockState,
    ...state
  };
  return (0, _testJestHelpers.mountWithIntl)( /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
    state: testState
  }, /*#__PURE__*/_react.default.createElement(_rtl_helpers.MockRouter, {
    history: history,
    kibanaProps: kibanaProps,
    core: core
  }, ui)));
}