"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepScreenshotDisplay = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
var _public = require("@kbn/observability-shared-plugin/public");
var _runtime_types = require("../../../../common/runtime_types");
var _contexts = require("../../contexts");
var _journey = require("../../state/api/journey");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IMAGE_MAX_WIDTH = 640;
const StepImage = (0, _styledComponents.default)(_eui.EuiImage)`
  &&& {
    figcaption {
      display: none;
    }
    objectFit: 'cover',
    objectPosition: 'center top',
  }
`;
const BaseStepImage = ({
  stepIndex,
  stepName,
  url
}) => {
  if (!url) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  });
  return /*#__PURE__*/_react.default.createElement(StepImage, {
    allowFullScreen: true,
    alt: stepName ? _i18n.i18n.translate('xpack.synthetics.synthetics.screenshotDisplay.altText', {
      defaultMessage: 'Screenshot for step with name "{stepName}"',
      values: {
        stepName
      }
    }) : _i18n.i18n.translate('xpack.synthetics.synthetics.screenshotDisplay.altTextWithoutName', {
      defaultMessage: 'Screenshot'
    }),
    caption: `Step:${stepIndex} ${stepName}`,
    hasShadow: true,
    url: url
  });
};
const ComposedStepImage = ({
  stepIndex,
  stepName,
  url,
  imgRef,
  setUrl
}) => {
  (0, _hooks.useCompositeImage)(imgRef, setUrl, url);
  if (!url) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  });
  return /*#__PURE__*/_react.default.createElement(BaseStepImage, {
    stepIndex: stepIndex,
    stepName: stepName,
    url: url
  });
};
const StepScreenshotDisplay = ({
  checkGroup,
  isFullScreenshot: isScreenshotBlob,
  isScreenshotRef,
  stepIndex,
  stepName,
  lazyLoad = true
}) => {
  var _refDimensions$width, _refDimensions$height;
  const containerRef = (0, _react.useRef)(null);
  const {
    colors: {
      lightestShade: pageBackground
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const intersection = (0, _useIntersection.default)(containerRef, {
    root: null,
    rootMargin: '0px',
    threshold: 1
  });
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const [hasIntersected, setHasIntersected] = (0, _react.useState)(false);
  const isIntersecting = intersection === null || intersection === void 0 ? void 0 : intersection.isIntersecting;
  (0, _react.useEffect)(() => {
    if (hasIntersected === false && isIntersecting === true) {
      setHasIntersected(true);
    }
  }, [hasIntersected, isIntersecting, setHasIntersected]);
  const imgSrc = basePath + `/internal/uptime/journey/screenshot/${checkGroup}/${stepIndex}`;

  // When loading a legacy screenshot, set `url` to full-size screenshot path.
  // Otherwise, we first need to composite the image.
  const [url, setUrl] = (0, _react.useState)(isScreenshotBlob ? imgSrc : undefined);

  // when the image is a composite, we need to fetch the data since we cannot specify a blob URL
  const {
    data: screenshotRef
  } = (0, _public.useFetcher)(() => {
    if (isScreenshotRef) {
      return (0, _journey.getJourneyScreenshot)(imgSrc);
    }
  }, [basePath, checkGroup, imgSrc, stepIndex, isScreenshotRef, lastRefresh]);
  const refDimensions = (0, _react.useMemo)(() => {
    if ((0, _runtime_types.isScreenshotRef)(screenshotRef)) {
      const {
        height,
        width
      } = screenshotRef.ref.screenshotRef.screenshot_ref;
      return {
        height,
        width
      };
    }
  }, [screenshotRef]);
  const shouldRenderImage = hasIntersected || !lazyLoad;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    style: {
      backgroundColor: pageBackground,
      maxWidth: Math.min(IMAGE_MAX_WIDTH, (_refDimensions$width = refDimensions === null || refDimensions === void 0 ? void 0 : refDimensions.width) !== null && _refDimensions$width !== void 0 ? _refDimensions$width : Number.MAX_VALUE),
      maxHeight: (_refDimensions$height = refDimensions === null || refDimensions === void 0 ? void 0 : refDimensions.height) !== null && _refDimensions$height !== void 0 ? _refDimensions$height : undefined
    }
  }, shouldRenderImage && isScreenshotBlob && /*#__PURE__*/_react.default.createElement(BaseStepImage, {
    stepName: stepName,
    stepIndex: stepIndex,
    url: url
  }), shouldRenderImage && isScreenshotRef && (0, _runtime_types.isScreenshotRef)(screenshotRef) && /*#__PURE__*/_react.default.createElement(ComposedStepImage, {
    imgRef: screenshotRef,
    stepName: stepName,
    stepIndex: stepIndex,
    setUrl: setUrl,
    url: url
  }), !isScreenshotBlob && !isScreenshotRef && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    style: {
      paddingTop: '32px'
    },
    "data-test-subj": "stepScreenshotImageUnavailable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    size: "xxl",
    type: "image"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.screenshot.noImageMessage",
    defaultMessage: "No image available"
  }))))));
};
exports.StepScreenshotDisplay = StepScreenshotDisplay;