"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpandedStepCallback = getExpandedStepCallback;
exports.useExpandedRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _executed_step = require("../executed_step");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getExpandedStepCallback(key) {
  return step => {
    var _step$synthetics, _step$synthetics$step;
    return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step = _step$synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.index) === key;
  };
}
const useExpandedRow = ({
  loading,
  steps,
  allSteps
}) => {
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  // eui table uses index from 0, synthetics uses 1

  const {
    checkGroupId
  } = (0, _reactRouterDom.useParams)();
  const getBrowserConsoles = (0, _react.useCallback)(index => {
    return allSteps.filter(stepF => {
      var _stepF$synthetics, _stepF$synthetics2, _stepF$synthetics2$st;
      return ((_stepF$synthetics = stepF.synthetics) === null || _stepF$synthetics === void 0 ? void 0 : _stepF$synthetics.type) === 'journey/browserconsole' && ((_stepF$synthetics2 = stepF.synthetics) === null || _stepF$synthetics2 === void 0 ? void 0 : (_stepF$synthetics2$st = _stepF$synthetics2.step) === null || _stepF$synthetics2$st === void 0 ? void 0 : _stepF$synthetics2$st.index) === index;
    }).map(stepF => {
      var _stepF$synthetics3, _stepF$synthetics3$pa;
      return (_stepF$synthetics3 = stepF.synthetics) === null || _stepF$synthetics3 === void 0 ? void 0 : (_stepF$synthetics3$pa = _stepF$synthetics3.payload) === null || _stepF$synthetics3$pa === void 0 ? void 0 : _stepF$synthetics3$pa.text;
    });
  }, [allSteps]);
  (0, _react.useEffect)(() => {
    const expandedRowsN = {};
    for (const expandedRowKey of Object.keys(expandedRows).map(key => Number(key))) {
      const step = steps.find(getExpandedStepCallback(expandedRowKey + 1));
      if (step) {
        var _step$synthetics2, _step$synthetics2$ste;
        expandedRowsN[expandedRowKey] = /*#__PURE__*/_react.default.createElement(_executed_step.ExecutedStep, {
          step: step,
          browserConsoles: getBrowserConsoles(expandedRowKey),
          index: (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
          loading: loading
        });
      }
    }
    setExpandedRows(expandedRowsN);

    // we only want to update when checkGroupId changes
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [checkGroupId, loading]);
  const toggleExpand = ({
    journeyStep
  }) => {
    var _journeyStep$syntheti, _journeyStep$syntheti2;
    // eui table uses index from 0, synthetics uses 1
    const stepIndex = ((_journeyStep$syntheti = journeyStep.synthetics) === null || _journeyStep$syntheti === void 0 ? void 0 : (_journeyStep$syntheti2 = _journeyStep$syntheti.step) === null || _journeyStep$syntheti2 === void 0 ? void 0 : _journeyStep$syntheti2.index) - 1;

    // If already expanded, collapse
    if (expandedRows[stepIndex]) {
      delete expandedRows[stepIndex];
      setExpandedRows({
        ...expandedRows
      });
    } else {
      var _journeyStep$syntheti3, _journeyStep$syntheti4;
      // Otherwise expand this row
      setExpandedRows({
        ...expandedRows,
        [stepIndex]: /*#__PURE__*/_react.default.createElement(_executed_step.ExecutedStep, {
          step: journeyStep,
          browserConsoles: getBrowserConsoles(stepIndex + 1),
          index: (_journeyStep$syntheti3 = journeyStep.synthetics) === null || _journeyStep$syntheti3 === void 0 ? void 0 : (_journeyStep$syntheti4 = _journeyStep$syntheti3.step) === null || _journeyStep$syntheti4 === void 0 ? void 0 : _journeyStep$syntheti4.index,
          loading: loading
        })
      });
    }
  };
  return {
    expandedRows,
    toggleExpand
  };
};
exports.useExpandedRow = useExpandedRow;