"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepScreenshots = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _step_screenshot_display = require("../../step_screenshot_display");
var _journey = require("../../../../state/api/journey");
var _screenshot_link = require("./screenshot_link");
var _monitor_status_column = require("../../../overview/monitor_list/columns/monitor_status_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Label = _common.euiStyled.div`
  margin-bottom: ${props => props.theme.eui.euiSizeXS};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
  color: ${({
  theme
}) => theme.eui.euiColorDarkShade};
`;
const StepScreenshots = ({
  step
}) => {
  var _step$synthetics, _step$synthetics$payl, _step$synthetics3, _step$synthetics3$pay, _step$synthetics4, _step$synthetics4$pay, _step$synthetics5, _step$synthetics6, _step$synthetics7, _step$synthetics7$ste, _step$synthetics8, _step$synthetics8$ste, _lastSuccessfulCheck$, _lastSuccessfulCheck$2, _step$synthetics9, _step$synthetics9$ste, _step$synthetics10, _step$synthetics10$st;
  const isSucceeded = ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$payl = _step$synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status) === 'succeeded';
  const {
    data
  } = (0, _public.useFetcher)(() => {
    if (!isSucceeded) {
      var _step$synthetics2, _step$synthetics2$ste, _step$observer, _step$observer$geo;
      return (0, _journey.fetchLastSuccessfulCheck)({
        timestamp: step['@timestamp'],
        monitorId: step.monitor.id,
        stepIndex: (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
        location: (_step$observer = step.observer) === null || _step$observer === void 0 ? void 0 : (_step$observer$geo = _step$observer.geo) === null || _step$observer$geo === void 0 ? void 0 : _step$observer$geo.name
      });
    }
  }, [step._id, step['@timestamp']]);
  const lastSuccessfulCheck = data;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Label, null, ((_step$synthetics3 = step.synthetics) === null || _step$synthetics3 === void 0 ? void 0 : (_step$synthetics3$pay = _step$synthetics3.payload) === null || _step$synthetics3$pay === void 0 ? void 0 : _step$synthetics3$pay.status) !== 'succeeded' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.executedStep.screenshot.notSucceeded",
    defaultMessage: "Screenshot for {status} check",
    values: {
      status: (_step$synthetics4 = step.synthetics) === null || _step$synthetics4 === void 0 ? void 0 : (_step$synthetics4$pay = _step$synthetics4.payload) === null || _step$synthetics4$pay === void 0 ? void 0 : _step$synthetics4$pay.status
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.executedStep.screenshot.not",
    defaultMessage: "Screenshot"
  })), /*#__PURE__*/_react.default.createElement(_step_screenshot_display.StepScreenshotDisplay, {
    checkGroup: step.monitor.check_group,
    isScreenshotRef: Boolean((_step$synthetics5 = step.synthetics) === null || _step$synthetics5 === void 0 ? void 0 : _step$synthetics5.isScreenshotRef),
    isFullScreenshot: Boolean((_step$synthetics6 = step.synthetics) === null || _step$synthetics6 === void 0 ? void 0 : _step$synthetics6.isFullScreenshot),
    stepIndex: (_step$synthetics7 = step.synthetics) === null || _step$synthetics7 === void 0 ? void 0 : (_step$synthetics7$ste = _step$synthetics7.step) === null || _step$synthetics7$ste === void 0 ? void 0 : _step$synthetics7$ste.index,
    stepName: (_step$synthetics8 = step.synthetics) === null || _step$synthetics8 === void 0 ? void 0 : (_step$synthetics8$ste = _step$synthetics8.step) === null || _step$synthetics8$ste === void 0 ? void 0 : _step$synthetics8$ste.name,
    lazyLoad: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(Label, null, (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(step['@timestamp'])))), !isSucceeded && (lastSuccessfulCheck === null || lastSuccessfulCheck === void 0 ? void 0 : lastSuccessfulCheck.monitor) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_screenshot_link.ScreenshotLink, {
    lastSuccessfulCheck: lastSuccessfulCheck
  }), /*#__PURE__*/_react.default.createElement(_step_screenshot_display.StepScreenshotDisplay, {
    checkGroup: lastSuccessfulCheck.monitor.check_group,
    isScreenshotRef: Boolean((_lastSuccessfulCheck$ = lastSuccessfulCheck.synthetics) === null || _lastSuccessfulCheck$ === void 0 ? void 0 : _lastSuccessfulCheck$.isScreenshotRef),
    isFullScreenshot: Boolean((_lastSuccessfulCheck$2 = lastSuccessfulCheck.synthetics) === null || _lastSuccessfulCheck$2 === void 0 ? void 0 : _lastSuccessfulCheck$2.isFullScreenshot),
    stepIndex: (_step$synthetics9 = step.synthetics) === null || _step$synthetics9 === void 0 ? void 0 : (_step$synthetics9$ste = _step$synthetics9.step) === null || _step$synthetics9$ste === void 0 ? void 0 : _step$synthetics9$ste.index,
    stepName: (_step$synthetics10 = step.synthetics) === null || _step$synthetics10 === void 0 ? void 0 : (_step$synthetics10$st = _step$synthetics10.step) === null || _step$synthetics10$st === void 0 ? void 0 : _step$synthetics10$st.name,
    lazyLoad: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(Label, null, (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(lastSuccessfulCheck.timestamp)))));
};
exports.StepScreenshots = StepScreenshots;