"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MostRecentError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _stringify_url_params = require("../../../../lib/helper/url_params/stringify_url_params");
var _monitor_page_link = require("../../../common/monitor_page_link");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MostRecentError = ({
  error,
  monitorId,
  timestamp
}) => {
  const params = (0, _hooks.useGetUrlParams)();
  params.statusFilter = 'down';
  const linkParameters = (0, _stringify_url_params.stringifyUrlParams)(params, true);
  const timestampStr = timestamp ? (0, _moment.default)(new Date(timestamp).valueOf()).fromNow() : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.synthetics.monitorList.mostRecentError.title', {
    defaultMessage: 'Most recent error ({timestamp})',
    values: {
      timestamp: timestampStr
    },
    description: 'Most Recent Error title in Monitor List Expanded row'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_monitor_page_link.MonitorPageLink, {
    monitorId: monitorId,
    linkParameters: linkParameters
  }, error === null || error === void 0 ? void 0 : error.message)));
};
exports.MostRecentError = MostRecentError;