"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var labels = _interopRequireWildcard(require("../translations"));
var _uptime_data_view_context = require("../../../../contexts/uptime_data_view_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddFilterButton = ({
  newFilters,
  onNewFilter,
  alertFilters
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const getSelectedItems = fieldName => {
    var _alertFilters$fieldNa;
    return (_alertFilters$fieldNa = alertFilters === null || alertFilters === void 0 ? void 0 : alertFilters[fieldName]) !== null && _alertFilters$fieldNa !== void 0 ? _alertFilters$fieldNa : [];
  };
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const items = [];
  const allFilters = [{
    id: 'observer.geo.name',
    label: labels.LOCATION
  }, {
    id: 'tags',
    label: labels.TAG
  }, {
    id: 'url.port',
    label: labels.PORT
  }, {
    id: 'monitor.type',
    label: labels.TYPE
  }];
  allFilters.forEach(filter => {
    var _getSelectedItems;
    if (((_getSelectedItems = getSelectedItems(filter.id)) === null || _getSelectedItems === void 0 ? void 0 : _getSelectedItems.length) === 0 && !newFilters.includes(filter.id)) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": 'uptimeAlertAddFilter.' + filter.id,
        key: filter.id,
        onClick: () => {
          closePopover();
          onNewFilter(filter.id);
        }
      }, filter.label));
    }
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "uptimeCreateAlertAddFilter",
    disabled: items.length === 0,
    iconType: "plusInCircleFilled",
    onClick: onButtonClick,
    size: "s",
    flush: "left",
    isLoading: !dataView
  }, labels.ADD_FILTER);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "singlePanel",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  }));
};
exports.AddFilterButton = AddFilterButton;