"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("./constants");
var _waterfall_chart = require("../context/waterfall_chart");
var _styles = require("./styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Sidebar = ({
  items,
  render
}) => {
  const {
    onSidebarClick
  } = (0, _waterfall_chart.useWaterfallContext)();
  const handleSidebarClick = (0, _react.useMemo)(() => onSidebarClick, [onSidebarClick]);
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarContainer, {
    height: items.length * _constants.FIXED_AXIS_HEIGHT,
    "data-test-subj": "wfSidebarContainer"
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarContainerInnerPanel, {
    paddingSize: "none",
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarContainerFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, items.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarFlexItem, {
      key: index
    }, render(item, index, handleSidebarClick));
  })))));
};
exports.Sidebar = Sidebar;