"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusByLocations = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusByLocations = ({
  locations
}) => {
  const upLocations = [];
  const downLocations = [];
  if (locations) locations.forEach(item => {
    if (item.summary.down === 0) {
      upLocations.push(item.geo.name);
    } else {
      downLocations.push(item.geo.name);
    }
  });
  let statusMessage = '';
  let status = '';
  if (downLocations.length === 0) {
    // for Messaging like 'Up in 1 Location' or 'Up in 2 Locations'
    statusMessage = `${locations.length}`;
    status = 'Up';
  } else if (downLocations.length > 0) {
    // for Messaging like 'Down in 1/2 Locations'
    status = 'Down';
    statusMessage = `${downLocations.length}/${locations.length}`;
    if (downLocations.length === locations.length) {
      // for Messaging like 'Down in 2 Locations'
      statusMessage = `${locations.length}`;
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, locations.length <= 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorStatusBar.locations.oneLocStatus",
    values: {
      status,
      loc: statusMessage
    },
    defaultMessage: "{status} in {loc} location"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorStatusBar.locations.upStatus",
    values: {
      status,
      loc: statusMessage
    },
    defaultMessage: "{status} in {loc} locations"
  })));
};
exports.StatusByLocations = StatusByLocations;