"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorSSLCertificate = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _status_bar = require("./status_bar");
var _cert_status_column = require("../../../overview/monitor_list/columns/cert_status_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorSSLCertificate = ({
  tls
}) => {
  var _tls$server;
  let expiry = null;
  if (tls !== null && tls !== void 0 && (_tls$server = tls.server) !== null && _tls$server !== void 0 && _tls$server.x509) {
    expiry = tls.server.x509;
  } else if (tls !== null && tls !== void 0 && tls.certificate_not_valid_after && tls !== null && tls !== void 0 && tls.certificate_not_valid_before) {
    expiry = {
      not_after: tls.certificate_not_valid_after,
      not_before: tls.certificate_not_valid_before
    };
  }
  if (!expiry) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_status_bar.MonListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorStatusBar.sslCertificate.title",
    defaultMessage: "TLS Certificate"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_status_bar.MonListDescription, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
    to: _constants.CERTIFICATES_ROUTE,
    className: "eui-displayInline"
  }, /*#__PURE__*/_react.default.createElement(_cert_status_column.CertStatusColumn, {
    expiry: expiry,
    boldStyle: true
  }))));
};
exports.MonitorSSLCertificate = MonitorSSLCertificate;