"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorRedirects = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _ping_redirects = require("../../ping_list/ping_redirects");
var _status_bar = require("./status_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectBtn = _styledComponents.default.span`
  cursor: pointer;
`;
const MonitorRedirects = ({
  monitorStatus
}) => {
  var _monitorStatus$http, _monitorStatus$http$r, _list$length;
  const list = monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$http = monitorStatus.http) === null || _monitorStatus$http === void 0 ? void 0 : (_monitorStatus$http$r = _monitorStatus$http.response) === null || _monitorStatus$http$r === void 0 ? void 0 : _monitorStatus$http$r.redirects;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_status_bar.MonListDescription, null, /*#__PURE__*/_react.default.createElement(RedirectBtn, {
    className: "euiLink euiLink--primary",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    "data-test-subj": "uptimeMonitorRedirectInfo"
  }, _i18n.i18n.translate('xpack.synthetics.monitorList.redirects.title.number', {
    defaultMessage: '{number}',
    values: {
      number: (_list$length = list === null || list === void 0 ? void 0 : list.length) !== null && _list$length !== void 0 ? _list$length : 0
    }
  })));
  return list ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_status_bar.MonListTitle, null, "Redirects"), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    anchorPosition: "downLeft",
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_ping_redirects.PingRedirects, {
    monitorStatus: monitorStatus
  }))) : null;
};
exports.MonitorRedirects = MonitorRedirects;