"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingListTable = PingListTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var I18LABELS = _interopRequireWildcard(require("./translations"));
var _ping_status = require("./columns/ping_status");
var _location_name = require("./location_name");
var _constants = require("../../../../../common/constants");
var _ping_timestamp = require("./columns/ping_timestamp");
var _monitor_status_column = require("../../overview/monitor_list/columns/monitor_status_column");
var _ping_error = require("./columns/ping_error");
var _failed_step = require("./columns/failed_step");
var _response_code = require("./columns/response_code");
var _expand_row = require("./columns/expand_row");
var _ping_list = require("./ping_list");
var _actions = require("../../../state/actions");
var _journey = require("../../../state/actions/journey");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PingListTable({
  loading,
  error,
  pings,
  pagination,
  onChange,
  failedSteps
}) {
  var _pings$;
  const history = (0, _reactRouterDom.useHistory)();
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  const expandedIdsToRemove = JSON.stringify(Object.keys(expandedRows).filter(e => !pings.some(({
    docId
  }) => docId === e)));
  const dispatch = (0, _reactRedux.useDispatch)();
  const pruneJourneysCallback = (0, _react.useCallback)(checkGroups => dispatch((0, _journey.pruneJourneyState)(checkGroups)), [dispatch]);
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _actions.clearPings)());
    };
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    const parsed = JSON.parse(expandedIdsToRemove);
    if (parsed.length) {
      parsed.forEach(docId => {
        delete expandedRows[docId];
      });
      setExpandedRows(expandedRows);
    }
  }, [expandedIdsToRemove, expandedRows]);
  const expandedCheckGroups = pings.filter(p => Object.keys(expandedRows).some(f => p.docId === f)).map(({
    monitor: {
      check_group: cg
    }
  }) => cg);
  const expandedCheckGroupsStr = JSON.stringify(expandedCheckGroups);
  (0, _react.useEffect)(() => {
    pruneJourneysCallback(JSON.parse(expandedCheckGroupsStr));
  }, [pruneJourneysCallback, expandedCheckGroupsStr]);
  const hasStatus = pings.reduce((hasHttpStatus, currentPing) => {
    var _currentPing$http, _currentPing$http$res;
    return hasHttpStatus || !!((_currentPing$http = currentPing.http) !== null && _currentPing$http !== void 0 && (_currentPing$http$res = _currentPing$http.response) !== null && _currentPing$http$res !== void 0 && _currentPing$http$res.status_code);
  }, false);
  const hasError = pings.reduce((errorType, currentPing) => {
    var _currentPing$error;
    return errorType || !!((_currentPing$error = currentPing.error) !== null && _currentPing$error !== void 0 && _currentPing$error.type);
  }, false);
  const monitorType = pings === null || pings === void 0 ? void 0 : (_pings$ = pings[0]) === null || _pings$ === void 0 ? void 0 : _pings$.monitor.type;
  const columns = [{
    field: 'monitor.status',
    name: I18LABELS.STATUS_LABEL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_ping_status.PingStatusColumn, {
      pingStatus: pingStatus,
      item: item
    })
  }, {
    align: 'left',
    field: 'observer.geo.name',
    name: I18LABELS.LOCATION_LABEL,
    render: location => /*#__PURE__*/_react.default.createElement(_location_name.LocationName, {
      location: location
    })
  }, ...(monitorType === _constants.MONITOR_TYPES.BROWSER ? [{
    align: 'left',
    field: 'timestamp',
    name: I18LABELS.TIMESTAMP_LABEL,
    render: (timestamp, item) => /*#__PURE__*/_react.default.createElement(_ping_timestamp.PingTimestamp, {
      checkGroup: item.monitor.check_group,
      label: (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(timestamp))
    })
  }] : []),
  // ip column not needed for browser type
  ...(monitorType !== _constants.MONITOR_TYPES.BROWSER ? [{
    align: 'right',
    dataType: 'number',
    field: 'monitor.ip',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.ipAddressColumnLabel', {
      defaultMessage: 'IP'
    })
  }] : []), {
    align: 'center',
    field: 'monitor.duration.us',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.durationMsColumnLabel', {
      defaultMessage: 'Duration'
    }),
    render: duration => duration ? (0, _ping_list.formatDuration)(duration) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "ping-list-duration-unavailable-tool-tip"
    }, '--')
  }, ...(hasError ? [{
    field: 'error.type',
    name: I18LABELS.ERROR_LABEL,
    width: '30%',
    render: (errorType, item) => /*#__PURE__*/_react.default.createElement(_ping_error.PingErrorCol, {
      ping: item,
      errorType: errorType
    })
  }] : []), ...(monitorType === _constants.MONITOR_TYPES.BROWSER ? [{
    field: 'monitor.status',
    align: 'left',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.columns.failedStep', {
      defaultMessage: 'Failed step'
    }),
    render: (_timestamp, item) => {
      var _item$monitor;
      return /*#__PURE__*/_react.default.createElement(_failed_step.FailedStep, {
        checkGroup: (_item$monitor = item.monitor) === null || _item$monitor === void 0 ? void 0 : _item$monitor.check_group,
        failedSteps: failedSteps
      });
    }
  }] : []),
  // Only add this column is there is any status present in list
  ...(hasStatus ? [{
    field: 'http.response.status_code',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_ping_list.SpanWithMargin, null, I18LABELS.RES_CODE_LABEL),
    render: statusCode => /*#__PURE__*/_react.default.createElement(_response_code.ResponseCodeColumn, {
      statusCode: statusCode
    })
  }] : []), ...(monitorType !== _constants.MONITOR_TYPES.BROWSER ? [{
    align: 'right',
    width: '24px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_expand_row.ExpandRowColumn, {
      item: item,
      expandedRows: expandedRows,
      setExpandedRows: setExpandedRows
    })
  }] : [])];
  const getRowProps = item => {
    if (monitorType !== _constants.MONITOR_TYPES.BROWSER) {
      return {};
    }
    const {
      monitor
    } = item;
    return {
      height: '85px',
      'data-test-subj': `row-${monitor.check_group}`,
      onClick: evt => {
        const targetElem = evt.target;

        // we dont want to capture image click event
        if (targetElem.tagName !== 'IMG' && targetElem.tagName !== 'path') {
          history.push(`/journey/${monitor.check_group}/steps`);
        }
      }
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    isExpandable: true,
    hasActions: true,
    items: pings,
    itemId: "docId",
    itemIdToExpandedRowMap: expandedRows,
    pagination: pagination,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.synthetics.pingList.pingsLoadingMesssage', {
      defaultMessage: 'Loading history...'
    }) : _i18n.i18n.translate('xpack.synthetics.pingList.pingsUnavailableMessage', {
      defaultMessage: 'No history found'
    }),
    tableLayout: 'auto',
    rowProps: getRowProps,
    onChange: onChange
  });
}