"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocLinkForBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodyDocsLink = 'https://www.elastic.co/guide/en/beats/heartbeat/current/configuration-heartbeat-options.html#monitor-http-response';
const DocLinkForBody = () => {
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsDocLinkForBodyDocsLink",
    href: bodyDocsLink,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.synthetics.pingList.drawer.body.docsLink', {
    defaultMessage: 'docs',
    description: 'Docs link to set response body'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.pingList.expandedRow.response_body.notRecorded",
    defaultMessage: "Body not recorded. Read our {docsLink} for more information on recording response bodies.",
    values: {
      docsLink
    }
  }));
};
exports.DocLinkForBody = DocLinkForBody;