"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingStatusColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../../contexts");
var _translations = require("../../../../../../common/translations/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPingStatusLabel = (status, ping) => {
  if (ping.monitor.type === _constants.MONITOR_TYPES.BROWSER) {
    return status === 'up' ? _translations.STATUS_COMPLETE_LABEL : _translations.STATUS_FAILED_LABEL;
  }
  return status === 'up' ? _translations.STATUS_UP_LABEL : _translations.STATUS_DOWN_LABEL;
};
const PingStatusColumn = ({
  pingStatus,
  item
}) => {
  const {
    colors: {
      dangerBehindText
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  const timeStamp = (0, _moment.default)(item.timestamp);
  let checkedTime = '';
  if ((0, _moment.default)().diff(timeStamp, 'd') > 1) {
    checkedTime = timeStamp.format('ll LTS');
  } else {
    checkedTime = timeStamp.format('LTS');
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `xpack.synthetics.pingList.ping-${item.docId}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textCenter",
    color: pingStatus === _constants.STATUS.UP ? 'success' : dangerBehindText
  }, getPingStatusLabel(pingStatus, item)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.synthetics.pingList.recencyMessage', {
    values: {
      fromNow: checkedTime
    },
    defaultMessage: 'Checked {fromNow}',
    description: 'A string used to inform our users how long ago Heartbeat pinged the selected host.'
  })));
};
exports.PingStatusColumn = PingStatusColumn;