"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDuration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _hooks = require("../../../hooks");
var _actions = require("../../../state/actions");
var _selectors = require("../../../state/selectors");
var _contexts = require("../../../contexts");
var _monitor_duration = require("./monitor_duration");
var _lib = require("../../../../../common/lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDuration = ({
  monitorId
}) => {
  var _durationLines$locati;
  const {
    dateRangeStart,
    dateRangeEnd,
    absoluteDateRangeStart,
    absoluteDateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    durationLines,
    loading
  } = (0, _reactRedux.useSelector)(_selectors.selectDurationLines);
  const isMLAvailable = (0, _reactRedux.useSelector)(_selectors.hasMLFeatureSelector);
  const {
    data: mlJobs,
    loading: jobsLoading
  } = (0, _reactRedux.useSelector)(_selectors.hasMLJobSelector);
  const hasMLJob = !!(mlJobs !== null && mlJobs !== void 0 && mlJobs.jobsExist) && !!mlJobs.jobs.find(job => job.id === (0, _lib.getMLJobId)(monitorId));
  const anomalies = (0, _reactRedux.useSelector)(_selectors.anomaliesSelector);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  (0, _react.useEffect)(() => {
    if (isMLAvailable && hasMLJob) {
      const anomalyParams = {
        listOfMonitorIds: [monitorId],
        dateStart: absoluteDateRangeStart,
        dateEnd: absoluteDateRangeEnd
      };
      dispatch(_actions.getAnomalyRecordsAction.get(anomalyParams));
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dateRangeStart, dateRangeEnd, dispatch, lastRefresh, monitorId, isMLAvailable, hasMLJob]);
  (0, _react.useEffect)(() => {
    const params = {
      monitorId,
      dateStart: dateRangeStart,
      dateEnd: dateRangeEnd
    };
    dispatch((0, _actions.getMonitorDurationAction)(params));
  }, [dateRangeStart, dateRangeEnd, dispatch, lastRefresh, monitorId]);
  (0, _react.useEffect)(() => {
    dispatch(_actions.getMLCapabilitiesAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_monitor_duration.MonitorDurationComponent, {
    anomalies: anomalies,
    hasMLJob: hasMLJob,
    loading: loading || jobsLoading,
    locationDurationLines: (_durationLines$locati = durationLines === null || durationLines === void 0 ? void 0 : durationLines.locationDurationLines) !== null && _durationLines$locati !== void 0 ? _durationLines$locati : []
  });
};
exports.MonitorDuration = MonitorDuration;