"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLIntegrationComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _ml_flyout_container = require("./ml_flyout_container");
var _selectors = require("../../../state/selectors");
var _actions = require("../../../state/actions");
var _confirm_delete = require("./confirm_delete");
var _contexts = require("../../../contexts");
var labels = _interopRequireWildcard(require("./translations"));
var _manage_ml_job = require("./manage_ml_job");
var _hooks = require("../../../hooks");
var _lib = require("../../../../../common/lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MLIntegrationComponent = () => {
  const [isMlFlyoutOpen, setIsMlFlyoutOpen] = (0, _react.useState)(false);
  const [isConfirmDeleteJobOpen, setIsConfirmDeleteJobOpen] = (0, _react.useState)(false);
  const {
    lastRefresh,
    refreshApp
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    notifications
  } = (0, _public.useKibana)();
  const monitorId = (0, _hooks.useMonitorId)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isMLAvailable = (0, _reactRedux.useSelector)(_selectors.hasMLFeatureSelector);
  const deleteMLJob = () => dispatch(_actions.deleteMLJobAction.get({
    monitorId: monitorId
  }));
  const isMLJobDeleting = (0, _reactRedux.useSelector)(_selectors.isMLJobDeletingSelector);
  const {
    data: jobDeletionSuccess
  } = (0, _reactRedux.useSelector)(_selectors.isMLJobDeletedSelector);
  const {
    data: uptimeJobs
  } = (0, _reactRedux.useSelector)(_selectors.hasMLJobSelector);
  const hasMLJob = !!(uptimeJobs !== null && uptimeJobs !== void 0 && uptimeJobs.jobsExist) && !!uptimeJobs.jobs.find(job => job.id === (0, _lib.getMLJobId)(monitorId));
  (0, _react.useEffect)(() => {
    if (isMLAvailable) {
      dispatch(_actions.getExistingMLJobAction.get({
        monitorId: monitorId
      }));
    }
  }, [dispatch, isMLAvailable, monitorId, lastRefresh]);
  (0, _react.useEffect)(() => {
    var _jobDeletionSuccess$g;
    if (isConfirmDeleteJobOpen && jobDeletionSuccess !== null && jobDeletionSuccess !== void 0 && (_jobDeletionSuccess$g = jobDeletionSuccess[(0, _lib.getMLJobId)(monitorId)]) !== null && _jobDeletionSuccess$g !== void 0 && _jobDeletionSuccess$g.deleted) {
      setIsConfirmDeleteJobOpen(false);
      notifications.toasts.success({
        title: /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeMLJobSuccessfullyDeleted"
        }, labels.JOB_DELETION),
        body: /*#__PURE__*/_react.default.createElement("p", null, labels.JOB_DELETION_SUCCESS),
        toastLifeTimeMs: 3000
      });
      dispatch((0, _actions.resetMLState)());
      refreshApp();
    }
    return () => {
      dispatch((0, _actions.resetMLState)());
    };
  }, [isMLJobDeleting, isConfirmDeleteJobOpen, jobDeletionSuccess, monitorId, refreshApp, notifications.toasts, dispatch]);
  const onEnableJobClick = () => {
    setIsMlFlyoutOpen(true);
  };
  const closeFlyout = () => {
    setIsMlFlyoutOpen(false);
  };
  const confirmDeleteMLJob = () => {
    setIsConfirmDeleteJobOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_manage_ml_job.ManageMLJobComponent, {
    hasMLJob: hasMLJob,
    onEnableJob: onEnableJobClick,
    onJobDelete: confirmDeleteMLJob
  }), isMlFlyoutOpen && /*#__PURE__*/_react.default.createElement(_ml_flyout_container.MachineLearningFlyout, {
    onClose: closeFlyout
  }), isConfirmDeleteJobOpen && /*#__PURE__*/_react.default.createElement(_confirm_delete.ConfirmJobDeletion, {
    onConfirm: deleteMLJob,
    loading: isMLJobDeleting,
    onCancel: () => {
      setIsConfirmDeleteJobOpen(false);
    }
  }));
};
exports.MLIntegrationComponent = MLIntegrationComponent;