"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsPolicyEditExtensionWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _runtime_types = require("../../../../common/runtime_types");
var _deprecate_notice_modal = require("./deprecate_notice_modal");
var _hooks = require("../../../apps/synthetics/hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Exports Synthetics-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const SyntheticsPolicyEditExtensionWrapper = /*#__PURE__*/(0, _react.memo)(({
  policy: currentPolicy,
  newPolicy,
  onChange
}) => {
  var _useKibana$services, _useKibana$services$s, _useKibana$services$s2, _currentInput$streams, _vars$ConfigKey$CONFI;
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    package: pkg
  } = newPolicy;
  const onCancel = (0, _react.useCallback)(() => {
    application === null || application === void 0 ? void 0 : application.navigateToApp('integrations', {
      path: `/detail/${pkg === null || pkg === void 0 ? void 0 : pkg.name}-${pkg === null || pkg === void 0 ? void 0 : pkg.version}/overview`
    });
  }, [application, pkg === null || pkg === void 0 ? void 0 : pkg.name, pkg === null || pkg === void 0 ? void 0 : pkg.version]);
  const locators = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$s = _useKibana$services.share) === null || _useKibana$services$s === void 0 ? void 0 : (_useKibana$services$s2 = _useKibana$services$s.url) === null || _useKibana$services$s2 === void 0 ? void 0 : _useKibana$services$s2.locators;
  const currentInput = currentPolicy.inputs.find(input => input.enabled === true);
  const vars = currentInput === null || currentInput === void 0 ? void 0 : (_currentInput$streams = currentInput.streams.find(stream => Object.values(_runtime_types.DataStream).includes(stream.data_stream.dataset))) === null || _currentInput$streams === void 0 ? void 0 : _currentInput$streams.vars;
  const configId = vars === null || vars === void 0 ? void 0 : (_vars$ConfigKey$CONFI = vars[_runtime_types.ConfigKey.CONFIG_ID]) === null || _vars$ConfigKey$CONFI === void 0 ? void 0 : _vars$ConfigKey$CONFI.value;
  const url = (0, _hooks.useEditMonitorLocator)({
    configId,
    locators
  });
  if (currentPolicy.is_managed) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, null, /*#__PURE__*/_react.default.createElement("p", null, EDIT_IN_SYNTHETICS_DESC), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: !url,
      href: url + `?packagePolicyId=${currentPolicy.id}`,
      "data-test-subj": "syntheticsEditMonitorButton"
    }, EDIT_IN_SYNTHETICS_LABEL));
  } else {
    return /*#__PURE__*/_react.default.createElement(_deprecate_notice_modal.DeprecateNoticeModal, {
      onCancel: onCancel
    });
  }
});
exports.SyntheticsPolicyEditExtensionWrapper = SyntheticsPolicyEditExtensionWrapper;
SyntheticsPolicyEditExtensionWrapper.displayName = 'SyntheticsPolicyEditExtensionWrapper';
const EDIT_IN_SYNTHETICS_LABEL = _i18n.i18n.translate('xpack.synthetics.editPackagePolicy.inSynthetics', {
  defaultMessage: 'Edit in Synthetics'
});
const EDIT_IN_SYNTHETICS_DESC = _i18n.i18n.translate('xpack.synthetics.editPackagePolicy.inSyntheticsDesc', {
  defaultMessage: 'This package policy is managed by the Synthetics app.'
});