"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockKibanaProvider = MockKibanaProvider;
exports.MockRedux = void 0;
exports.MockRouter = MockRouter;
exports.WrappedHelper = WrappedHelper;
exports.mockCore = exports.makeUptimePermissionsCore = exports.makeSyntheticsPermissionsCore = exports.forNearestButton = exports.forNearestAnchor = exports.forMobileOnly = exports.forDesktopOnly = exports.defaultCore = void 0;
exports.render = render;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _react2 = require("@testing-library/react");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _lodash = require("lodash");
var _history = require("history");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mocks = require("@kbn/core/public/mocks");
var _dom = require("@testing-library/dom");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _mocks2 = require("@kbn/triggers-actions-ui-plugin/public/mocks");
var _mocks3 = require("@kbn/data-plugin/public/mocks");
var _synthetics_store = require("./__mocks__/synthetics_store.mock");
var _helper_with_redux = require("./helper_with_redux");
var _url_params = require("../url_params");
var _contexts = require("../../contexts");
var _kibana_service = require("../../../../utils/kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

// eslint-disable-next-line import/no-extraneous-dependencies

function getSetting(key) {
  return 'MMM D, YYYY @ HH:mm:ss.SSS';
}
function setSetting$(key) {
  return (0, _rxjs.of)('MMM D, YYYY @ HH:mm:ss.SSS');
}
const createMockStore = () => {
  let store = {};
  return {
    get: jest.fn().mockImplementation(key => store[key]),
    set: jest.fn().mockImplementation((key, value) => store[key] = value),
    remove: jest.fn().mockImplementation(key => delete store[key]),
    clear: jest.fn().mockImplementation(() => store = {})
  };
};
const mockAppUrls = {
  uptime: '/app/uptime',
  synthetics: '/app/synthetics',
  observability: '/app/observability',
  '/home#/tutorial/uptimeMonitors': '/home#/tutorial/uptimeMonitors'
};

/* default mock core */
const defaultCore = _mocks.coreMock.createStart();
exports.defaultCore = defaultCore;
const mockCore = () => {
  const core = {
    ...defaultCore,
    application: {
      ...defaultCore.application,
      getUrlForApp: app => mockAppUrls[app],
      navigateToUrl: jest.fn(),
      capabilities: {
        ...defaultCore.application.capabilities,
        uptime: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true
        },
        actions: {
          save: true
        }
      }
    },
    uiSettings: {
      ...defaultCore.uiSettings,
      get: getSetting,
      get$: setSetting$
    },
    settings: {
      client: {
        ...defaultCore.settings.client,
        get: getSetting,
        get$: setSetting$
      },
      globalClient: defaultCore.settings.globalClient
    },
    usageCollection: {
      reportUiCounter: () => {}
    },
    triggersActionsUi: _mocks2.triggersActionsUiMock.createStart(),
    storage: createMockStore(),
    data: _mocks3.dataPluginMock.createStartContract(),
    // @ts-ignore
    observability: {
      useRulesLink: () => ({
        href: 'newRuleLink'
      }),
      observabilityRuleTypeRegistry: {
        register: jest.fn(),
        getFormatter: jest.fn(),
        list: jest.fn()
      }
    },
    observabilityShared: {
      navigation: {
        // @ts-ignore
        PageTemplate: _eui.EuiPageTemplate_Deprecated
      }
    },
    exploratoryView: {
      createExploratoryViewUrl: jest.fn(),
      getAppDataView: jest.fn(),
      ExploratoryViewEmbeddable: () => /*#__PURE__*/_react.default.createElement("div", null, "Embeddable exploratory view")
    }
  };
  return core;
};

/* Mock Provider Components */
exports.mockCore = mockCore;
function MockKibanaProvider({
  children,
  core,
  kibanaProps
}) {
  const coreOptions = (0, _lodash.merge)({}, mockCore(), core);
  _kibana_service.kibanaService.core = coreOptions;
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, (0, _extends2.default)({
    services: {
      ...coreOptions
    }
  }, kibanaProps), /*#__PURE__*/_react.default.createElement(_contexts.SyntheticsRefreshContextProvider, null, /*#__PURE__*/_react.default.createElement(_contexts.SyntheticsStartupPluginsContextProvider, {
    data: coreOptions.data,
    observability: coreOptions.observability,
    observabilityShared: coreOptions.observabilityShared,
    exploratoryView: coreOptions.exploratoryView
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, children)))));
}
function MockRouter({
  children,
  core,
  path,
  history = (0, _history.createMemoryHistory)(),
  kibanaProps
}) {
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(MockKibanaProvider, {
    core: core,
    kibanaProps: kibanaProps
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path
  }, children)));
}
(0, _dom.configure)({
  testIdAttribute: 'data-test-subj'
});
const MockRedux = ({
  state,
  history = (0, _history.createMemoryHistory)(),
  children,
  path
}) => {
  const testState = {
    ..._synthetics_store.mockState,
    ...state
  };
  return /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
    state: testState
  }, /*#__PURE__*/_react.default.createElement(MockRouter, {
    path: path,
    history: history
  }, children));
};
exports.MockRedux = MockRedux;
function WrappedHelper({
  children,
  core,
  kibanaProps,
  state,
  url,
  useRealStore,
  path,
  history = (0, _history.createMemoryHistory)()
}) {
  const testState = (0, _lodash.mergeWith)({}, _synthetics_store.mockState, state, (objValue, srcValue) => {
    if (Array.isArray(objValue)) {
      return srcValue;
    }
  });
  if (url) {
    history = getHistoryFromUrl(url);
  }
  return /*#__PURE__*/_react.default.createElement(_helper_with_redux.MountWithReduxProvider, {
    state: testState,
    useRealStore: useRealStore
  }, /*#__PURE__*/_react.default.createElement(MockRouter, {
    path: path,
    history: history,
    kibanaProps: kibanaProps,
    core: core
  }, children));
}

/* Custom react testing library render */
function render(ui, {
  history = (0, _history.createMemoryHistory)(),
  core,
  kibanaProps,
  renderOptions,
  state,
  url,
  path,
  useRealStore
} = {}) {
  if (url) {
    history = getHistoryFromUrl(url);
  }
  return {
    ...(0, _react2.render)( /*#__PURE__*/_react.default.createElement(WrappedHelper, {
      history: history,
      kibanaProps: kibanaProps,
      core: core,
      url: url,
      state: state,
      path: path,
      useRealStore: useRealStore
    }, ui), renderOptions),
    history
  };
}
const getHistoryFromUrl = url => {
  if (typeof url === 'string') {
    return (0, _history.createMemoryHistory)({
      initialEntries: [url]
    });
  }
  return (0, _history.createMemoryHistory)({
    initialEntries: [url.path + (0, _url_params.stringifyUrlParams)(url.queryParams)]
  });
};
const forNearestTag = tag => getByText => text => getByText((_content, node) => {
  if (!node) return false;
  const noOtherButtonHasText = Array.from(node.children).every(child => child && (child.textContent !== text || child.tagName.toLowerCase() !== tag));
  return noOtherButtonHasText && node.textContent === text && node.tagName.toLowerCase() === tag;
});

// This function allows us to query for the nearest button with test
// no matter whether it has nested tags or not (as EuiButton elements do).
const forNearestButton = forNearestTag('button');
exports.forNearestButton = forNearestButton;
const forNearestAnchor = forNearestTag('a');
exports.forNearestAnchor = forNearestAnchor;
const makeSyntheticsPermissionsCore = permissions => {
  return {
    application: {
      capabilities: {
        uptime: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true,
          ...permissions
        }
      }
    }
  };
};

// This function filters out the queried elements which appear only
// either on mobile or desktop.
//
// It does so by filtering those with the class passed as the `classWrapper`.
// For mobile, we filter classes which tell elements to be hidden on desktop.
// For desktop, we do the opposite.
//
// We have this function because EUI will manipulate the visibility of some
// elements through pure CSS, which we can't assert on tests. Therefore,
// we look for the corresponding class wrapper.
exports.makeSyntheticsPermissionsCore = makeSyntheticsPermissionsCore;
const finderWithClassWrapper = classWrapper => (getterFn, customAttribute) => text => getterFn((_content, node) => {
  var _ref;
  if (!node) return false;
  // There are actually properties that are not in Element but which
  // appear on the `node`, so we must cast the customAttribute as a keyof Element
  const content = node[(_ref = customAttribute) !== null && _ref !== void 0 ? _ref : 'innerHTML'];
  if (content === text && wrappedInClass(node, classWrapper)) return true;
  return false;
});
const wrappedInClass = (element, classWrapper) => {
  if (element.className.includes(classWrapper)) return true;
  if (element.parentElement) return wrappedInClass(element.parentElement, classWrapper);
  return false;
};
const forMobileOnly = finderWithClassWrapper('hideForDesktop');
exports.forMobileOnly = forMobileOnly;
const forDesktopOnly = finderWithClassWrapper('hideForMobile');
exports.forDesktopOnly = forDesktopOnly;
const makeUptimePermissionsCore = permissions => {
  return {
    application: {
      capabilities: {
        uptime: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true,
          ...permissions
        }
      }
    }
  };
};
exports.makeUptimePermissionsCore = makeUptimePermissionsCore;