"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncGlobalParamsAPI = exports.setDynamicSettings = exports.getDynamicSettings = exports.fetchLocationMonitors = exports.fetchConnectors = exports.fetchActionTypes = void 0;
var _api_service = require("../../../../utils/api_service");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiPath = _constants.API_URLS.DYNAMIC_SETTINGS;
const getDynamicSettings = async () => {
  return await _api_service.apiService.get(apiPath, undefined, _runtime_types.DynamicSettingsCodec);
};
exports.getDynamicSettings = getDynamicSettings;
const setDynamicSettings = async ({
  settings
}) => {
  return await _api_service.apiService.post(apiPath, settings, _runtime_types.DynamicSettingsSaveCodec);
};
exports.setDynamicSettings = setDynamicSettings;
const fetchLocationMonitors = async () => {
  const {
    payload
  } = await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_MONITORS, undefined, _runtime_types.LocationMonitorsType);
  return payload;
};
exports.fetchLocationMonitors = fetchLocationMonitors;
const fetchConnectors = async () => {
  const response = await _api_service.apiService.get(_constants.API_URLS.RULE_CONNECTORS);
  return response.map(({
    connector_type_id: actionTypeId,
    referenced_by_count: referencedByCount,
    is_preconfigured: isPreconfigured,
    is_deprecated: isDeprecated,
    is_missing_secrets: isMissingSecrets,
    ...res
  }) => ({
    ...res,
    actionTypeId,
    referencedByCount,
    isDeprecated,
    isPreconfigured,
    isMissingSecrets
  }));
};
exports.fetchConnectors = fetchConnectors;
const fetchActionTypes = async () => {
  const response = await _api_service.apiService.get(_constants.API_URLS.CONNECTOR_TYPES, {
    feature_id: 'uptime'
  });
  return response.map(({
    enabled_in_config: enabledInConfig,
    enabled_in_license: enabledInLicense,
    minimum_license_required: minimumLicenseRequired,
    supported_feature_ids: supportedFeatureIds,
    ...res
  }) => ({
    ...res,
    enabledInConfig,
    enabledInLicense,
    minimumLicenseRequired,
    supportedFeatureIds
  }));
};
exports.fetchActionTypes = fetchActionTypes;
const syncGlobalParamsAPI = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.SYNC_GLOBAL_PARAMS);
};
exports.syncGlobalParamsAPI = syncGlobalParamsAPI;