"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  monitorListReducer: true,
  fetchDeleteMonitor: true,
  fetchUpsertMonitor: true,
  createGettingStartedMonitor: true
};
Object.defineProperty(exports, "createGettingStartedMonitor", {
  enumerable: true,
  get: function () {
    return _api.createGettingStartedMonitor;
  }
});
Object.defineProperty(exports, "fetchDeleteMonitor", {
  enumerable: true,
  get: function () {
    return _api.fetchDeleteMonitor;
  }
});
Object.defineProperty(exports, "fetchUpsertMonitor", {
  enumerable: true,
  get: function () {
    return _api.fetchUpsertMonitor;
  }
});
exports.monitorListReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _public = require("@kbn/observability-shared-plugin/public");
var _helpers = require("./helpers");
Object.keys(_helpers).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _helpers[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _helpers[key];
    }
  });
});
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _api = require("./api");
Object.keys(_api).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _api[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _api[key];
    }
  });
});
var _models = require("./models");
Object.keys(_models).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _models[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _models[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  data: {
    page: 1,
    perPage: 10,
    total: null,
    monitors: [],
    syncErrors: [],
    absoluteTotal: 0
  },
  monitorUpsertStatuses: {},
  pageState: (0, _helpers.getMonitorListPageStateWithDefaults)(),
  loading: false,
  loaded: false,
  error: null,
  monitorFilterOptions: null
};
const monitorListReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.updateManagementPageStateAction, (state, action) => {
    state.pageState = {
      ...state.pageState,
      ...action.payload
    };
  }).addCase(_actions.fetchMonitorListAction.get, state => {
    state.loading = true;
    state.loaded = false;
  }).addCase(_actions.fetchMonitorListAction.success, (state, action) => {
    state.loading = false;
    state.loaded = true;
    state.error = null;
    state.data = action.payload;
  }).addCase(_actions.fetchMonitorListAction.fail, (state, action) => {
    state.loading = false;
    state.error = action.payload;
  }).addCase(_actions.fetchUpsertMonitorAction, (state, action) => {
    state.monitorUpsertStatuses[action.payload.configId] = {
      status: _public.FETCH_STATUS.LOADING
    };
  }).addCase(_actions.fetchUpsertSuccessAction, (state, action) => {
    state.monitorUpsertStatuses[action.payload.id] = {
      status: _public.FETCH_STATUS.SUCCESS,
      enabled: action.payload.attributes.enabled
    };
  }).addCase(_actions.fetchUpsertFailureAction, (state, action) => {
    state.monitorUpsertStatuses[action.payload.configId] = {
      status: _public.FETCH_STATUS.FAILURE
    };
  }).addCase(_actions.enableMonitorAlertAction.get, (state, action) => {
    state.monitorUpsertStatuses[action.payload.configId] = {
      ...state.monitorUpsertStatuses[action.payload.configId],
      alertStatus: _public.FETCH_STATUS.LOADING
    };
  }).addCase(_actions.enableMonitorAlertAction.success, (state, action) => {
    state.monitorUpsertStatuses[action.payload.id] = {
      ...state.monitorUpsertStatuses[action.payload.id],
      alertStatus: _public.FETCH_STATUS.SUCCESS
    };
    if ('updated_at' in action.payload) {
      state.data.monitors = state.data.monitors.map(monitor => {
        if (monitor.config_id === action.payload.id) {
          return action.payload.attributes;
        }
        return monitor;
      });
    }
  }).addCase(_actions.enableMonitorAlertAction.fail, (state, action) => {
    state.monitorUpsertStatuses[action.payload.configId] = {
      ...state.monitorUpsertStatuses[action.payload.configId],
      alertStatus: _public.FETCH_STATUS.FAILURE
    };
  }).addCase(_actions.clearMonitorUpsertStatus, (state, action) => {
    if (state.monitorUpsertStatuses[action.payload]) {
      delete state.monitorUpsertStatuses[action.payload];
    }
  }).addCase(_actions.cleanMonitorListState, state => {
    return {
      ...initialState,
      pageState: state.pageState
    };
  }).addCase(_actions.fetchMonitorFiltersAction.success, (state, action) => {
    state.monitorFilterOptions = action.payload;
  }).addCase(_actions.fetchMonitorFiltersAction.fail, (state, action) => {
    state.error = action.payload;
  });
});
exports.monitorListReducer = monitorListReducer;