"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableMonitorAlertEffect = enableMonitorAlertEffect;
exports.fetchMonitorFiltersEffect = fetchMonitorFiltersEffect;
exports.fetchMonitorListEffect = fetchMonitorListEffect;
exports.upsertMonitorEffect = upsertMonitorEffect;
var _effects = require("redux-saga/effects");
var _overview_status = require("../overview_status");
var _alert_rules = require("../alert_rules");
var _runtime_types = require("../../../../../common/runtime_types");
var _kibana_service = require("../../../../utils/kibana_service");
var _actions = require("../overview/actions");
var _selectors = require("../overview/selectors");
var _fetch_effect = require("../utils/fetch_effect");
var _http_error = require("../utils/http_error");
var _actions2 = require("./actions");
var _api = require("./api");
var _toast_title = require("./toast_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchMonitorListEffect() {
  yield (0, _effects.debounce)(300,
  // Only take the latest while ignoring any intermediate triggers
  [_actions2.fetchMonitorListAction.get, _actions2.quietFetchMonitorListAction], (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorManagementList, _actions2.fetchMonitorListAction.success, _actions2.fetchMonitorListAction.fail));
}
function* enableMonitorAlertEffect() {
  yield (0, _effects.takeEvery)(_actions2.enableMonitorAlertAction.get, function* (action) {
    try {
      var _attributes$ConfigKey, _attributes$ConfigKey2;
      const response = yield (0, _effects.call)(_api.fetchUpsertMonitor, action.payload);
      yield (0, _effects.put)(_actions2.enableMonitorAlertAction.success(response));
      (0, _fetch_effect.sendSuccessToast)(action.payload.success);
      if ((_attributes$ConfigKey = response.attributes[_runtime_types.ConfigKey.ALERT_CONFIG]) !== null && _attributes$ConfigKey !== void 0 && (_attributes$ConfigKey2 = _attributes$ConfigKey.status) !== null && _attributes$ConfigKey2 !== void 0 && _attributes$ConfigKey2.enabled) {
        yield (0, _effects.put)(_alert_rules.enableDefaultAlertingAction.get());
      }
    } catch (error) {
      (0, _fetch_effect.sendErrorToast)(action.payload.error, error);
      yield (0, _effects.put)(_actions2.enableMonitorAlertAction.fail({
        configId: action.payload.configId,
        error: (0, _http_error.serializeHttpFetchError)(error, action.payload)
      }));
    }
  });
}
function* upsertMonitorEffect() {
  yield (0, _effects.takeEvery)(_actions2.fetchUpsertMonitorAction, function* (action) {
    try {
      const response = yield (0, _effects.call)(_api.fetchUpsertMonitor, action.payload);
      yield (0, _effects.put)((0, _actions2.fetchUpsertSuccessAction)(response));
      _kibana_service.kibanaService.toasts.addSuccess({
        title: (0, _toast_title.toastTitle)({
          title: action.payload.success.message,
          testAttribute: action.payload.success.testAttribute
        }),
        toastLifeTimeMs: action.payload.success.lifetimeMs
      });
    } catch (error) {
      _kibana_service.kibanaService.toasts.addError(error, {
        ...action.payload.error.message,
        toastLifeTimeMs: action.payload.error.lifetimeMs
      });
      yield (0, _effects.put)((0, _actions2.fetchUpsertFailureAction)({
        configId: action.payload.configId,
        error: (0, _http_error.serializeHttpFetchError)(error, action.payload)
      }));
    } finally {
      if (action.payload.shouldQuietFetchAfterSuccess !== false) {
        const monitorState = yield (0, _effects.select)(_selectors.selectOverviewState);
        if (hasPageState(monitorState)) {
          yield (0, _effects.put)(_actions.quietFetchOverviewAction.get(monitorState.pageState));
          yield (0, _effects.put)(_overview_status.quietFetchOverviewStatusAction.get({
            pageState: monitorState.pageState
          }));
        }
      }
      yield (0, _effects.put)((0, _actions2.clearMonitorUpsertStatus)(action.payload.configId));
    }
  });
}
function hasPageState(value) {
  return Object.keys(value).includes('pageState');
}
function* fetchMonitorFiltersEffect() {
  yield (0, _effects.takeLatest)(_actions2.fetchMonitorFiltersAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorFilters, _actions2.fetchMonitorFiltersAction.success, _actions2.fetchMonitorFiltersAction.fail));
}