"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.triggerTestNowMonitor = exports.runOnceMonitor = void 0;
var _api_service = require("../../../../utils/api_service");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const triggerTestNowMonitor = async ({
  configId
}) => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.TRIGGER_MONITOR + `/${configId}`);
};
exports.triggerTestNowMonitor = triggerTestNowMonitor;
const runOnceMonitor = async ({
  monitor,
  id
}) => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.RUN_ONCE_MONITOR + `/${id}`, monitor);
};
exports.runOnceMonitor = runOnceMonitor;