"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalParams = exports.editGlobalParam = exports.deleteGlobalParams = exports.addGlobalParam = void 0;
var _constants = require("../../../../../common/constants");
var _api_service = require("../../../../utils/api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGlobalParams = async () => {
  const result = await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PARAMS);
  return result.data;
};
exports.getGlobalParams = getGlobalParams;
const addGlobalParam = async paramRequest => {
  return _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.PARAMS, paramRequest);
};
exports.addGlobalParam = addGlobalParam;
const editGlobalParam = async ({
  paramRequest,
  id
}) => {
  return _api_service.apiService.put(_constants.SYNTHETICS_API_URLS.PARAMS, {
    id,
    ...paramRequest
  });
};
exports.editGlobalParam = editGlobalParam;
const deleteGlobalParams = async ({
  ids
}) => {
  return _api_service.apiService.delete(_constants.SYNTHETICS_API_URLS.PARAMS, {
    ids: JSON.stringify(ids)
  });
};
exports.deleteGlobalParams = deleteGlobalParams;