"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FAILED_TO_SCHEDULE = exports.BrowserTestRunResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_service = require("../../../../../utils/kibana_service");
var _use_browser_run_once_monitors = require("../hooks/use_browser_run_once_monitors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BrowserTestRunResult = ({
  name,
  expectPings,
  onDone,
  testRunId,
  onProgress
}) => {
  const {
    summariesLoading,
    expectedSummariesLoaded,
    stepLoadingInProgress,
    checkGroupResults,
    retriesExceeded
  } = (0, _use_browser_run_once_monitors.useBrowserRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    if (retriesExceeded) {
      _kibana_service.kibanaService.toasts.addDanger({
        text: FAILED_TO_SCHEDULE,
        title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.manualTestRun.failedTest.name",
          defaultMessage: "Manual test run failed for {name}",
          values: {
            name
          }
        }))
      }, {
        toastLifeTimeMs: 10000
      });
      onDone(testRunId);
    }
  }, [name, onDone, retriesExceeded, testRunId]);
  (0, _react.useEffect)(() => {
    if (expectedSummariesLoaded) {
      onDone(testRunId);
    }
  }, [onDone, expectedSummariesLoaded, testRunId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, checkGroupResults.map(checkGroupResult => {
    var _summaryDoc$error2, _summaryDoc$error2$me;
    const {
      checkGroupId,
      journeyStarted,
      summaryDoc,
      stepsLoading,
      steps,
      completedSteps
    } = checkGroupResult;
    const isStepsLoading = !summariesLoading && journeyStarted && summaryDoc && stepsLoading;
    const isStepsLoadingFailed = summaryDoc && !summariesLoading && !stepLoadingInProgress && steps.length === 0;
    if (completedSteps > 0) {
      onProgress(_i18n.i18n.translate('xpack.synthetics.monitorManagement.stepCompleted', {
        defaultMessage: '{stepCount, number} {stepCount, plural, one {step} other {steps}}  completed',
        values: {
          stepCount: completedSteps !== null && completedSteps !== void 0 ? completedSteps : 0
        }
      }));
    }
    if (isStepsLoading) {
      onProgress(LOADING_STEPS);
    }
    if (isStepsLoadingFailed) {
      var _summaryDoc$error$mes, _summaryDoc$error;
      // TODO: Add error toast
      onProgress((_summaryDoc$error$mes = summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$error = summaryDoc.error) === null || _summaryDoc$error === void 0 ? void 0 : _summaryDoc$error.message) !== null && _summaryDoc$error$mes !== void 0 ? _summaryDoc$error$mes : FAILED_TO_RUN);
      // <EuiText color="danger">{summaryDoc?.error?.message ?? FAILED_TO_RUN}</EuiText>
    }

    if (isStepsLoadingFailed && summaryDoc !== null && summaryDoc !== void 0 && (_summaryDoc$error2 = summaryDoc.error) !== null && _summaryDoc$error2 !== void 0 && (_summaryDoc$error2$me = _summaryDoc$error2.message) !== null && _summaryDoc$error2$me !== void 0 && _summaryDoc$error2$me.includes('journey did not finish executing')) {
      // TODO: Add error toast
      // <StdErrorLogs checkGroup={summaryDoc.monitor.check_group} hideTitle={true} />;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: 'accordion-' + checkGroupId
    });
  }));
};
exports.BrowserTestRunResult = BrowserTestRunResult;
const FAILED_TO_RUN = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failedRun', {
  defaultMessage: 'Failed to run steps'
});
const FAILED_TO_SCHEDULE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failedScheduling', {
  defaultMessage: 'Failed to get any results back for manual test run.'
});
exports.FAILED_TO_SCHEDULE = FAILED_TO_SCHEDULE;
const LOADING_STEPS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.loadingSteps', {
  defaultMessage: 'Loading steps...'
});