"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRunOnceErrors = useRunOnceErrors;
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRunOnceErrors({
  testRunId,
  serviceError,
  errors,
  locations,
  showErrors = true
}) {
  var _errorMessages$;
  const [locationErrors, setLocationErrors] = (0, _react.useState)([]);
  const [runOnceServiceError, setRunOnceServiceError] = (0, _react.useState)(null);
  const publicLocations = (0, _react.useMemo)(() => (locations !== null && locations !== void 0 ? locations : []).filter(loc => loc.isServiceManaged), [locations]);
  (0, _react.useEffect)(() => {
    setLocationErrors([]);
    setRunOnceServiceError(null);
  }, [testRunId]);
  (0, _react.useEffect)(() => {
    if (locationErrors.length || errors.length) {
      setLocationErrors(errors);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [errors]);
  (0, _react.useEffect)(() => {
    if ((runOnceServiceError === null || runOnceServiceError === void 0 ? void 0 : runOnceServiceError.message) !== (serviceError === null || serviceError === void 0 ? void 0 : serviceError.message)) {
      setRunOnceServiceError(serviceError);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [serviceError]);
  const locationsById = (0, _react.useMemo)(() => publicLocations.reduce((acc, cur) => ({
    ...acc,
    [cur.id]: cur
  }), {}), [publicLocations]);
  const expectPings = publicLocations.length - (locationErrors !== null && locationErrors !== void 0 ? locationErrors : []).filter(({
    locationId
  }) => !!locationId).length;
  const locationErrorReasons = (0, _react.useMemo)(() => {
    return (locationErrors !== null && locationErrors !== void 0 ? locationErrors : []).map(({
      error
    }) => error === null || error === void 0 ? void 0 : error.reason).filter(reason => !!reason).filter((reason, i, arr) => arr.indexOf(reason) === i);
  }, [locationErrors]);
  const hasBlockingError = !!runOnceServiceError || (locationErrors === null || locationErrors === void 0 ? void 0 : locationErrors.length) && (locationErrors === null || locationErrors === void 0 ? void 0 : locationErrors.length) === publicLocations.length;
  const errorMessages = (0, _react.useMemo)(() => {
    if (hasBlockingError) {
      var _locationErrorReasons;
      return locationErrorReasons.length === 1 ? [{
        name: 'Error',
        message: (_locationErrorReasons = locationErrorReasons[0]) !== null && _locationErrorReasons !== void 0 ? _locationErrorReasons : PushErrorService,
        title: RunErrorLabel
      }] : [{
        name: 'Error',
        message: PushErrorService,
        title: RunErrorLabel
      }];
    } else if ((locationErrors === null || locationErrors === void 0 ? void 0 : locationErrors.length) > 0) {
      // If only some of the locations were unsuccessful
      return locationErrors.map(({
        locationId,
        error
      }) => ({
        location: locationsById[locationId],
        error
      })).filter(locationWithError => !!locationWithError.location).map(({
        location,
        error
      }) => {
        var _error$reason;
        return {
          name: 'Error',
          message: getLocationTestErrorLabel(location.label, (_error$reason = error === null || error === void 0 ? void 0 : error.reason) !== null && _error$reason !== void 0 ? _error$reason : ''),
          title: RunErrorLabel
        };
      });
    }
    return [];
  }, [locationsById, locationErrors, locationErrorReasons, hasBlockingError]);
  return {
    expectPings,
    hasBlockingError,
    blockingErrorTitle: hasBlockingError ? RunErrorLabel : null,
    blockingErrorMessage: hasBlockingError ? `${(_errorMessages$ = errorMessages[0]) === null || _errorMessages$ === void 0 ? void 0 : _errorMessages$.message}` : null,
    errorMessages
  };
}
const RunErrorLabel = _i18n.i18n.translate('xpack.synthetics.testRun.runErrorLabel', {
  defaultMessage: "Can't run the test now"
});
const getLocationTestErrorLabel = (locationName, reason) => _i18n.i18n.translate('xpack.synthetics.testRun.runErrorLocation.reason', {
  defaultMessage: 'Failed to run test on location {locationName}. {reason}',
  values: {
    locationName,
    reason
  }
});
const PushErrorService = _i18n.i18n.translate('xpack.synthetics.testRun.pushError', {
  defaultMessage: 'This test cannot be executed at this time. Try again later.'
});