"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallBarChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _use_chart_theme = require("../../../../../../hooks/use_chart_theme");
var _constants = require("./constants");
var _styles = require("./styles");
var _waterfall_context = require("./context/waterfall_context");
var _waterfall_tooltip_content = require("./waterfall_tooltip_content");
var _data_formatting = require("../../common/network_data/data_formatting");
var _waterfall_markers = require("./waterfall_marker/waterfall_markers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChartHeight = data => {
  // We get the last item x(number of bars) and adds 1 to cater for 0 index
  const noOfXBars = new Set(data.map(item => item.x)).size;
  return noOfXBars * _constants.BAR_HEIGHT;
};
const CustomTooltip = tooltipInfo => {
  var _tooltipInfo$header3;
  const {
    data,
    sidebarItems
  } = (0, _waterfall_context.useWaterfallContext)();
  return (0, _react.useMemo)(() => {
    const sidebarItem = sidebarItems === null || sidebarItems === void 0 ? void 0 : sidebarItems.find(item => {
      var _tooltipInfo$header;
      return item.index === ((_tooltipInfo$header = tooltipInfo.header) === null || _tooltipInfo$header === void 0 ? void 0 : _tooltipInfo$header.value);
    });
    const relevantItems = data.filter(item => {
      var _tooltipInfo$header2;
      return item.x === ((_tooltipInfo$header2 = tooltipInfo.header) === null || _tooltipInfo$header2 === void 0 ? void 0 : _tooltipInfo$header2.value) && item.config.showTooltip && item.config.tooltipProps;
    });
    return relevantItems.length ? /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTooltip, null, sidebarItem && /*#__PURE__*/_react.default.createElement(_waterfall_tooltip_content.WaterfallTooltipContent, {
      text: (0, _data_formatting.formatTooltipHeading)(sidebarItem.index + 1, sidebarItem.url),
      url: sidebarItem.url
    }))) : null;
  }, [data, sidebarItems, (_tooltipInfo$header3 = tooltipInfo.header) === null || _tooltipInfo$header3 === void 0 ? void 0 : _tooltipInfo$header3.value]);
};
const WaterfallBarChart = ({
  chartData,
  tickFormat,
  domain,
  barStyleAccessor,
  index
}) => {
  var _document$getElementB;
  const theme = (0, _use_chart_theme.useChartTheme)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onElementClick,
    onProjectionClick
  } = (0, _waterfall_context.useWaterfallContext)();
  const handleElementClick = (0, _react.useMemo)(() => onElementClick, [onElementClick]);
  const handleProjectionClick = (0, _react.useMemo)(() => onProjectionClick, [onProjectionClick]);
  const memoizedTickFormat = (0, _react.useCallback)(tickFormat, [tickFormat]);
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartChartContainer, {
    height: getChartHeight(chartData),
    chartIndex: index,
    "data-test-subj": "wfDataOnlyBarChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    className: "data-chart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip
  // this is done to prevent the waterfall tooltip from rendering behind Kibana's
  // stacked header when the user highlights an item at the top of the chart
  , {
    boundary: (_document$getElementB = document.getElementById('app-fixed-viewport')) !== null && _document$getElementB !== void 0 ? _document$getElementB : undefined,
    customTooltip: CustomTooltip
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    theme: {
      ...theme,
      tooltip: {
        maxWidth: 500
      }
    },
    onProjectionClick: handleProjectionClick,
    onElementClick: handleElementClick
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    "aria-hidden": true,
    id: "time",
    position: _charts.Position.Top,
    tickFormat: memoizedTickFormat,
    domain: domain,
    gridLine: {
      visible: true
    },
    style: {
      axisLine: {
        visible: false
      },
      tickLabel: {
        fontSize: 12,
        fill: euiTheme.colors.darkestShade
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "waterfallItems",
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    y0Accessors: ['y0'],
    styleAccessor: barStyleAccessor,
    data: chartData
  }), /*#__PURE__*/_react.default.createElement(_waterfall_markers.WaterfallChartMarkers, null)));
};
exports.WaterfallBarChart = WaterfallBarChart;