"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useParamsList = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _global_params = require("../../../state/global_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useParamsList = () => {
  const {
    isLoading,
    listOfParams
  } = (0, _reactRedux.useSelector)(_global_params.selectGlobalParamState);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_global_params.getGlobalParamAction.get());
  }, [dispatch]);
  return (0, _react.useMemo)(() => {
    var _listOfParams$map;
    return {
      items: (_listOfParams$map = listOfParams === null || listOfParams === void 0 ? void 0 : listOfParams.map(item => ({
        id: item.id,
        ...item.attributes,
        namespaces: item.namespaces
      }))) !== null && _listOfParams$map !== void 0 ? _listOfParams$map : [],
      isLoading
    };
  }, [listOfParams, isLoading]);
};
exports.useParamsList = useParamsList;