"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTestRunsSparkline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../../../../hooks");
var labels = _interopRequireWildcard(require("../labels"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorTestRunsSparkline = ({
  monitorIds
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const theme = (0, _public2.useTheme)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(30, 'days');
  const attributes = (0, _react.useMemo)(() => {
    return [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        'monitor.id': monitorIds.length > 0 ? monitorIds : ['false-monitor-id'] // Show no data when monitorIds is empty
      },

      dataType: 'synthetics',
      selectedMetricField: 'monitor.check_group',
      filters: [],
      name: labels.TEST_RUNS_LABEL,
      color: theme.eui.euiColorVis1,
      operationType: 'unique_count'
    }];
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [from, JSON.stringify({
    ids: [...monitorIds].sort()
  }), theme.eui.euiColorVis1, to]);
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitor-test-runs-sparkline",
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: attributes,
    customHeight: '68px'
  });
};
exports.MonitorTestRunsSparkline = MonitorTestRunsSparkline;