"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var labels = _interopRequireWildcard(require("../labels"));
var _monitor_test_runs = require("./monitor_test_runs");
var _monitor_test_runs_sparkline = require("./monitor_test_runs_sparkline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStats = ({
  overviewStatus
}) => {
  var _overviewStatus$allId, _overviewStatus$allId2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "syntheticsManagementSummaryStats",
    css: {
      display: 'flex',
      flexDirection: 'column',
      gap: euiTheme.size.l,
      flexGrow: 1
    },
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, labels.SUMMARY_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'flex',
      flexDirection: 'row',
      gap: euiTheme.size.l
    }
  }, /*#__PURE__*/_react.default.createElement(MonitorStat, {
    description: labels.CONFIGURATIONS_LABEL,
    value: overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allMonitorsCount
  }), /*#__PURE__*/_react.default.createElement(MonitorStat, {
    description: labels.DISABLED_LABEL,
    value: overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.disabledMonitorsCount
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      display: 'flex',
      flexDirection: 'column',
      gap: euiTheme.size.l,
      flexGrow: 12,
      minWidth: 260
    },
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, labels.getLastXDaysLabel(30))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'flex',
      flexDirection: 'row',
      gap: euiTheme.size.l,
      height: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_test_runs.MonitorTestRunsCount, {
    monitorIds: (_overviewStatus$allId = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allIds) !== null && _overviewStatus$allId !== void 0 ? _overviewStatus$allId : []
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_monitor_test_runs_sparkline.MonitorTestRunsSparkline, {
    monitorIds: (_overviewStatus$allId2 = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allIds) !== null && _overviewStatus$allId2 !== void 0 ? _overviewStatus$allId2 : []
  }))))));
};
exports.MonitorStats = MonitorStats;
const EuiStatStyled = (0, _common.euiStyled)(_eui.EuiStat)`
  &&& {
  color: ${({
  theme
}) => theme.eui.euiTitleColor};
    .euiStat__title {
        color: ${({
  theme
}) => theme.eui.euiTitleColor};
        font-size: ${({
  theme
}) => theme.eui.euiFontSizeXL};
    }
  }
`;
const MonitorStat = ({
  description,
  value
}) => {
  var _ref;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const statValue = (_ref = value) !== null && _ref !== void 0 ? _ref : undefined;
  return /*#__PURE__*/_react.default.createElement(EuiStatStyled, {
    description: description,
    isLoading: isNaN(statValue),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      css: {
        fontSize: euiTheme.size.m
      },
      value: statValue
    }),
    reverse: true
  });
};