"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorLocations = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _location_status_badges = require("../../../common/components/location_status_badges");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorLocations = ({
  locations,
  monitorId,
  status
}) => {
  const theme = (0, _public.useTheme)();
  const {
    locations: allLocations
  } = (0, _hooks.useLocations)();
  const locationsToDisplay = locations.map(loc => {
    const fullLoc = allLocations.find(l => l.id === loc.id);
    if (fullLoc) {
      return {
        id: fullLoc.id,
        label: fullLoc.label,
        ...getLocationStatusColor(theme, fullLoc.label, monitorId, status)
      };
    }
  }).filter(Boolean);
  return /*#__PURE__*/_react.default.createElement(_location_status_badges.LocationStatusBadges, {
    configId: monitorId,
    locations: locationsToDisplay,
    loading: false
  });
};
exports.MonitorLocations = MonitorLocations;
function getLocationStatusColor(euiTheme, locationLabel, monitorId, overviewStatus) {
  const {
    eui: {
      euiColorVis9,
      euiColorVis0,
      euiColorDisabled
    }
  } = euiTheme;
  const locById = `${monitorId}-${locationLabel}`;
  if (overviewStatus !== null && overviewStatus !== void 0 && overviewStatus.downConfigs[locById]) {
    return {
      status: 'down',
      color: euiColorVis9
    };
  } else if (overviewStatus !== null && overviewStatus !== void 0 && overviewStatus.upConfigs[locById]) {
    return {
      status: 'up',
      color: euiColorVis0
    };
  }
  return {
    status: 'unknown',
    color: euiColorDisabled
  };
}