"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilters = void 0;
exports.useMonitorFiltersState = useMonitorFiltersState;
var _react = require("react");
var _reactRedux = require("react-redux");
var _state = require("../../../../state");
var _contexts = require("../../../../contexts");
var _hooks = require("../../../../hooks");
var _filter_fields = require("../../../../utils/filters/filter_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilters = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const filtersData = (0, _reactRedux.useSelector)(_state.selectMonitorFilterOptions);
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  (0, _react.useEffect)(() => {
    dispatch(_state.fetchMonitorFiltersAction.get());
  }, [lastRefresh, dispatch]);
  return filtersData;
};
exports.useFilters = useFilters;
function useMonitorFiltersState() {
  const [getUrlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const urlParams = getUrlParams();
  const filterFieldsWithQuery = (0, _react.useMemo)(() => {
    const filterFields = (0, _filter_fields.getMonitorFilterFields)();
    return [...filterFields, 'query'];
  }, []);
  const dispatch = (0, _reactRedux.useDispatch)();
  const serializeFilterValue = (0, _react.useCallback)((field, selectedValues) => {
    if (field === 'query') {
      return selectedValues !== null && selectedValues !== void 0 && selectedValues.length ? selectedValues.toString() : undefined;
    }
    return selectedValues && selectedValues.length > 0 ? JSON.stringify(selectedValues.map(value => (0, _filter_fields.getSyntheticsFilterKeyForLabel)(value, field))) : undefined;
  }, []);
  const serializeStateValues = (0, _react.useCallback)(state => {
    return filterFieldsWithQuery.reduce((acc, cur) => ({
      ...acc,
      [cur]: serializeFilterValue(cur, state[cur])
    }), {});
  }, [filterFieldsWithQuery, serializeFilterValue]);
  const handleFilterChange = (0, _react.useCallback)((field, selectedValues) => {
    // Update url to reflect the changed filter
    updateUrlParams({
      [field]: serializeFilterValue(field, selectedValues)
    });
  }, [serializeFilterValue, updateUrlParams]);
  const reduxState = (0, _reactRedux.useSelector)(_state.selectMonitorFiltersAndQueryState);
  const reduxStateSnapshot = JSON.stringify(serializeStateValues(reduxState));
  const urlState = filterFieldsWithQuery.reduce((acc, cur) => ({
    ...acc,
    [cur]: urlParams[cur]
  }), {});
  const urlStateSerializedSnapshot = JSON.stringify(serializeStateValues(urlState));
  const isUrlHydratedFromRedux = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (urlStateSerializedSnapshot !== reduxStateSnapshot) {
      if (urlStateSerializedSnapshot === '{}' && reduxStateSnapshot !== '{}' && !isUrlHydratedFromRedux.current) {
        // Hydrate url only during initialization
        updateUrlParams(serializeStateValues(reduxState));
      } else {
        dispatch((0, _state.updateManagementPageStateAction)(urlState));
        dispatch((0, _state.setOverviewPageStateAction)(urlState));
      }
    }
    isUrlHydratedFromRedux.current = true;

    // Only depend on the serialized snapshot
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [urlStateSerializedSnapshot, reduxStateSnapshot]);
  return {
    handleFilterChange,
    filterState: reduxState
  };
}