"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDurationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _use_selected_location = require("../hooks/use_selected_location");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDurationPanel = ({
  legendPosition,
  doBreakdown = true
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const time = (0, _hooks.useAbsoluteDate)({
    from: 'now-24h/h',
    to: 'now'
  });
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const monitorId = (0, _use_monitor_query_id.useMonitorQueryId)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const isBrowser = (monitor === null || monitor === void 0 ? void 0 : monitor.type) === 'browser';
  if (!selectedLocation) {
    return null;
  }
  if (!monitorId) {
    return null;
  }
  const label = !doBreakdown ? MONITOR_DURATION : isBrowser ? DURATION_BY_STEP_LABEL : DURATION_BY_LOCATION;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, LAST_24H_LABEL))), /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "stepDurationLines",
    axisTitlesVisibility: {
      yLeft: false,
      yRight: false,
      x: false
    },
    customHeight: '300px',
    reportType: _public2.ReportTypes.KPI,
    legendPosition: legendPosition,
    legendIsVisible: doBreakdown,
    attributes: [{
      time,
      name: label,
      reportDefinitions: {
        'monitor.id': [monitorId],
        'observer.geo.name': [selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label]
      },
      selectedMetricField: isBrowser && doBreakdown ? 'synthetics.step.duration.us' : 'monitor.duration.us',
      dataType: 'synthetics',
      operationType: doBreakdown ? 'last_value' : 'average',
      seriesType: 'area_stacked',
      ...(doBreakdown ? {
        breakdown: isBrowser ? 'synthetics.step.name.keyword' : 'observer.geo.name'
      } : {})
    }]
  }));
};
exports.StepDurationPanel = StepDurationPanel;
const DURATION_BY_STEP_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.durationByStep', {
  defaultMessage: 'Duration by step'
});
const DURATION_BY_LOCATION = _i18n.i18n.translate('xpack.synthetics.detailsPanel.durationByLocation', {
  defaultMessage: 'Duration by location'
});
const MONITOR_DURATION = _i18n.i18n.translate('xpack.synthetics.detailsPanel.monitorDuration', {
  defaultMessage: 'Monitor duration'
});
const LAST_24H_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.last24Hours', {
  defaultMessage: 'Last 24 hours'
});