"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsUrl = exports.VIEW_ALERTS_LABEL = exports.AlertActions = exports.ACTIONS_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _alert_config = require("../../../../../../common/runtime_types/monitor_management/alert_config");
var _use_monitor_alert_enable = require("../../../hooks/use_monitor_alert_enable");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _labels = require("../../monitors_page/management/monitor_list_table/labels");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertActions = ({
  from,
  to,
  monitorId
}) => {
  var _monitor$alert, _monitor$alert$status;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    alertStatus,
    updateAlertEnabledState
  } = (0, _use_monitor_alert_enable.useMonitorAlertEnable)();
  const alertsUrl = useAlertsUrl({
    rangeFrom: from,
    rangeTo: to,
    monitorId
  });
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const isActionLoading = configId => {
    return alertStatus(configId) === _public.FETCH_STATUS.LOADING;
  };
  if (!monitor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    });
  }
  const onToggleAlertClick = () => {
    updateAlertEnabledState({
      monitor: {
        [_runtime_types.ConfigKey.ALERT_CONFIG]: (0, _alert_config.toggleStatusAlert)(monitor[_runtime_types.ConfigKey.ALERT_CONFIG])
      },
      name: monitor[_runtime_types.ConfigKey.NAME],
      configId: monitor[_runtime_types.ConfigKey.CONFIG_ID]
    });
  };
  const isAlertEnabled = (_monitor$alert = monitor.alert) === null || _monitor$alert === void 0 ? void 0 : (_monitor$alert$status = _monitor$alert.status) === null || _monitor$alert$status === void 0 ? void 0 : _monitor$alert$status.enabled;
  const isLoading = isActionLoading(monitor[_runtime_types.ConfigKey.CONFIG_ID]);
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "edit",
    icon: isAlertEnabled ? 'bellSlash' : 'bell',
    onClick: onToggleAlertClick,
    disabled: isLoading
  }, isAlertEnabled ? _labels.DISABLE_STATUS_ALERT : _labels.ENABLE_STATUS_ALERT, ' ', isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "share",
    icon: "list",
    href: alertsUrl
  }, VIEW_ALERTS_LABEL)];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsAlertActionsButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick
  }, ACTIONS_LABEL);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "monitorAlertActionsContext",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }));
};
exports.AlertActions = AlertActions;
const useAlertsUrl = ({
  rangeFrom,
  rangeTo,
  monitorId
}) => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  let kuery = 'kibana.alert.rule.category : "Synthetics monitor status" ';
  if (monitorId) {
    kuery += `AND monitor.id : "${monitorId}"`;
  }
  return `${basePath}/app/observability/alerts?_a=${_rison.default.encode({
    kuery,
    rangeFrom,
    rangeTo
  })}`;
};
exports.useAlertsUrl = useAlertsUrl;
const ACTIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.actions', {
  defaultMessage: 'Actions'
});
exports.ACTIONS_LABEL = ACTIONS_LABEL;
const VIEW_ALERTS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.actions.viewAlerts', {
  defaultMessage: 'View alerts'
});
exports.VIEW_ALERTS_LABEL = VIEW_ALERTS_LABEL;