"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingWrapper = exports.TextArea = exports.Switch = exports.Source = exports.Select = exports.ResponseBodyIndexField = exports.RequestBodyField = exports.MonitorTypeRadioGroup = exports.KeyValuePairsField = exports.JSONEditor = exports.HeaderField = exports.FormattedComboBox = exports.FieldText = exports.FieldPassword = exports.FieldNumber = exports.ComboBox = exports.Checkbox = exports.ButtonGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _throttling_config_field = require("../fields/throttling/throttling_config_field");
var _source_field = require("../fields/source_field");
var _combo_box = require("../fields/combo_box");
var _code_editor = require("../fields/code_editor");
var _monitor_type_radio_group = require("../fields/monitor_type_radio_group");
var _header_field = require("../fields/header_field");
var _key_value_field = require("../fields/key_value_field");
var _request_body_field = require("../fields/request_body_field");
var _index_response_body_field = require("../fields/index_response_body_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldText = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
  "data-test-subj": "syntheticsFieldTextFieldText"
}, (0, _lodash.omit)(props, ['defaultValue', 'selectedOptions']), {
  inputRef: ref
})));
exports.FieldText = FieldText;
const TextArea = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
  "data-test-subj": "syntheticsTextAreaTextArea"
}, props, {
  inputRef: ref
})));
exports.TextArea = TextArea;
const FieldNumber = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
  "data-test-subj": "syntheticsFieldNumberFieldNumber"
}, props, {
  inputRef: ref
})));
exports.FieldNumber = FieldNumber;
const FieldPassword = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, (0, _extends2.default)({}, props, {
  inputRef: ref
})));
exports.FieldPassword = FieldPassword;
const Checkbox = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, (0, _lodash.omit)(props, ['defaultValue', 'fullWidth', 'isInvalid'])));
exports.Checkbox = Checkbox;
const Select = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
  "data-test-subj": "syntheticsSelectSelect"
}, props, {
  inputRef: ref
})));
exports.Select = Select;
const Switch = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _lodash.omit)(props, ['fullWidth', 'isInvalid'])));
exports.Switch = Switch;
const Source = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_source_field.SourceField, props));
exports.Source = Source;
const ButtonGroup = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, (0, _lodash.omit)(props, ['isInvalid', 'fullWidth'])));
exports.ButtonGroup = ButtonGroup;
const FormattedComboBox = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_combo_box.FormattedComboBox, props));
exports.FormattedComboBox = FormattedComboBox;
const ComboBox = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _lodash.omit)(props, ['isServiceManaged'])));
exports.ComboBox = ComboBox;
const JSONEditor = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_code_editor.JSONEditor, props));
exports.JSONEditor = JSONEditor;
const MonitorTypeRadioGroup = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_monitor_type_radio_group.MonitorTypeRadioGroup, props));
exports.MonitorTypeRadioGroup = MonitorTypeRadioGroup;
const HeaderField = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_header_field.HeaderField, props));
exports.HeaderField = HeaderField;
const KeyValuePairsField = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_key_value_field.KeyValuePairsField, props));
exports.KeyValuePairsField = KeyValuePairsField;
const RequestBodyField = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_request_body_field.RequestBodyField, props));
exports.RequestBodyField = RequestBodyField;
const ResponseBodyIndexField = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_index_response_body_field.ResponseBodyIndexField, props));
exports.ResponseBodyIndexField = ResponseBodyIndexField;
const ThrottlingWrapper = /*#__PURE__*/_react.default.forwardRef((props, _ref) => /*#__PURE__*/_react.default.createElement(_throttling_config_field.ThrottlingConfigField, props));
exports.ThrottlingWrapper = ThrottlingWrapper;